/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.network.NetworkMessages;

public class ClientPacketHandlerAstroData
implements NetworkMessages.IMessage<ClientPacketHandlerAstroData> {
    private int entityID;
    private IAstroCapability.ICard draw;
    private IAstroCapability.ICard burn;
    private IAstroCapability.ICard spread;
    private int drawTime;

    public ClientPacketHandlerAstroData(PlayerEntity player) {
        IAstroCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.ASTRO);
        if (cap == null) {
            return;
        }
        this.entityID = player.func_145782_y();
        this.draw = cap.getDraw();
        this.burn = cap.getBurn();
        this.spread = cap.getSpread();
        this.drawTime = cap.getDrawTime();
    }

    @Override
    public void handle(PlayerEntity player) {
        PlayerEntity p;
        IAstroCapability cap;
        Entity e = player.field_70170_p.func_73045_a(this.entityID);
        if (e instanceof PlayerEntity && (cap = CapabilityList.getCap((ICapabilityProvider)(p = (PlayerEntity)e), CapabilityList.ASTRO)) != null) {
            cap.setDraw(this.draw);
            cap.setBurn(this.burn);
            cap.setSpread(this.spread);
            cap.setDrawTime(this.drawTime);
        }
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.entityID);
        packet.writeInt(IAstroCapability.ICard.getCardID(this.draw));
        packet.writeInt(IAstroCapability.ICard.getCardID(this.burn));
        packet.writeInt(IAstroCapability.ICard.getCardID(this.spread));
        packet.writeInt(this.drawTime);
    }

    @Override
    public ClientPacketHandlerAstroData fromBytes(PacketBuffer packet) {
        this.entityID = packet.readInt();
        this.draw = IAstroCapability.ICard.getCardFromID(packet.readInt());
        this.burn = IAstroCapability.ICard.getCardFromID(packet.readInt());
        this.spread = IAstroCapability.ICard.getCardFromID(packet.readInt());
        this.drawTime = packet.readInt();
        return this;
    }
}

