/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.registry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import tamaized.aov.AoV;
import tamaized.aov.network.client.ClientPacketHandlerParticle;

public class ParticleRegistry {
    private static final List<Supplier<IParticleHandler>> HANDLERS = Lists.newArrayList();

    public static int register(Supplier<IParticleHandler> handler) {
        HANDLERS.add(handler);
        return HANDLERS.size() - 1;
    }

    public static IParticleHandler getHandlerFromID(int id) {
        return id < 0 || id >= HANDLERS.size() ? null : HANDLERS.get(id).get();
    }

    public static void spawnFromServer(World world, int id, double x, double y, double z, double dx, double dy, double dz, int ... data) {
        AoV.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(new BlockPos(x, y, z))), (Object)new ClientPacketHandlerParticle(id, x, y, z, dx, dy, dz, data));
    }

    public static interface IParticleHandler {
        public void execute(ParticleManager var1, World var2, double var3, double var5, double var7, double var9, double var11, double var13, int ... var15);
    }
}

