/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.tileentity.TileBarrel;
import knightminer.ceramics.tileentity.TileBarrelBase;
import knightminer.ceramics.tileentity.TileBarrelExtension;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;

@Optional.Interface(iface="slimeknights.tconstruct.library.smeltery.IFaucetDepth", modid="tconstruct")
public class BlockBarrel
extends Block
implements ITileEntityProvider,
IFaucetDepth {
    public static PropertyBool EXTENSION = PropertyBool.func_177716_a((String)"extension");
    protected static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.0625, 0.875);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0625, 0.0, 0.875, 0.9375, 1.0, 0.9375);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.125, 1.0, 0.9375);
    protected static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AxisAlignedBB[] EXTENSION_BOUNDS = new AxisAlignedBB[]{AABB_WALL_NORTH, AABB_WALL_SOUTH, AABB_WALL_EAST, AABB_WALL_WEST};

    public BlockBarrel(Material material) {
        super(material);
        this.field_149758_A = true;
        this.func_149711_c(1.25f);
        this.func_149752_b(7.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(Ceramics.tab);
    }

    public BlockBarrel() {
        this(Material.field_151576_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)EXTENSION, (Comparable)Boolean.FALSE));
    }

    public boolean isExtension(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EXTENSION);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.isExtension(this.func_176203_a(meta))) {
            return new TileBarrelExtension();
        }
        return new TileBarrel();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBarrel) {
            ((TileBarrel)te).checkBarrelStructure();
        } else {
            te = world.func_175625_s(pos.func_177977_b());
            if (te instanceof TileBarrelBase) {
                ((TileBarrelBase)te).checkBarrelStructure();
            }
        }
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileBarrelExtension) {
            ((TileBarrelExtension)te).checkBarrelStructure();
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        if (FluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)fluidHandler, (EntityPlayer)player)) {
            return true;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack) != null;
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity te;
        float f = world.func_180494_b(pos).func_180626_a(pos);
        if (world.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && (te = world.func_175625_s(pos)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXTENSION});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta == 1) {
            state = state.func_177226_a((IProperty)EXTENSION, (Comparable)Boolean.TRUE);
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)EXTENSION)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return !this.isExtension(state);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBarrel) {
            return ((TileBarrel)te).comparatorStrength();
        }
        return 0;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity) {
        if (!this.isExtension(state)) {
            BlockBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BASE);
        }
        BlockBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockBarrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return BOUNDS;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        if (!this.isExtension(state)) {
            return super.func_180636_a(state, world, pos, start, end);
        }
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : EXTENSION_BOUNDS) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    @Optional.Method(modid="tconstruct")
    public float getFlowDepth(World world, BlockPos pos, IBlockState state) {
        if (this.isExtension(state)) {
            BlockPos master;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileBarrelExtension && (master = ((TileBarrelExtension)te).getMasterPos()) != null) {
                return 0.9375f + (float)pos.func_177956_o() - (float)master.func_177956_o();
            }
            return 1.0f;
        }
        return 0.9375f;
    }
}

