/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.client;

import javax.annotation.Nonnull;
import knightminer.ceramics.client.RenderUtils;
import knightminer.ceramics.library.BarrelTank;
import knightminer.ceramics.tileentity.TileBarrel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class BarrelRenderer
extends TileEntitySpecialRenderer<TileBarrel> {
    public static Minecraft mc = Minecraft.func_71410_x();

    public void renderTileEntityAt(@Nonnull TileBarrel barrel, double x, double y, double z, float partialTicks, int destroyStage) {
        BarrelTank tank = barrel.getTank();
        FluidStack fluid = tank.getFluid();
        if (fluid == null) {
            return;
        }
        BlockPos pos = barrel.func_174877_v();
        int blockHeight = 1;
        if (barrel.topPos != null) {
            pos = barrel.topPos;
            blockHeight = 1 + barrel.topPos.func_177956_o() - barrel.func_174877_v().func_177956_o();
        }
        float height = ((float)fluid.amount - (float)tank.renderOffset) / (float)tank.getCapacity() * (float)blockHeight - 0.0625f;
        height = Math.max(0.0675f, Math.min(height, (float)blockHeight - 0.0625f));
        tank.renderOffset = (float)tank.renderOffset > 1.2f || (float)tank.renderOffset < -1.2f ? (int)((float)tank.renderOffset - ((float)tank.renderOffset / 12.0f + 0.1f) * partialTicks) : 0;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BarrelRenderer.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtils.pre(x, y, z);
        GlStateManager.func_179129_p();
        TextureAtlasSprite sprite = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        double minU = sprite.func_94214_a(2.0);
        double maxU = sprite.func_94214_a(14.0);
        double minV = sprite.func_94207_b(2.0);
        double maxV = sprite.func_94207_b(14.0);
        int color = fluid.getFluid().getColor(fluid);
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int brightness = BarrelRenderer.mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        int light1 = brightness >> 16 & 0xFFFF;
        int light2 = brightness & 0xFFFF;
        renderer.func_181662_b(0.125, (double)height, 0.125).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
        renderer.func_181662_b(0.125, (double)height, 0.875).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
        renderer.func_181662_b(0.875, (double)height, 0.875).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
        renderer.func_181662_b(0.875, (double)height, 0.125).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        RenderUtils.post();
    }
}

