/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.client;

import javax.annotation.Nonnull;
import knightminer.ceramics.blocks.BlockFaucet;
import knightminer.ceramics.client.RenderUtils;
import knightminer.ceramics.library.IFaucetDepthFallback;
import knightminer.ceramics.tileentity.TileFaucet;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;

public class FaucetRenderer
extends TileEntitySpecialRenderer<TileFaucet> {
    private static IDepthGetter depth = Loader.isModLoaded((String)"tconstruct") ? new IDepthGetter(){

        @Override
        public float getDepth(World world, BlockPos pos, IBlockState state) {
            if (state.func_177230_c() instanceof IFaucetDepth) {
                return ((IFaucetDepth)state.func_177230_c()).getFlowDepth(world, pos, state);
            }
            return 0.9375f;
        }
    } : new IDepthGetter(){

        @Override
        public float getDepth(World world, BlockPos pos, IBlockState state) {
            if (state.func_177230_c() instanceof IFaucetDepthFallback) {
                return ((IFaucetDepthFallback)state.func_177230_c()).getFlowDepth(world, pos, state);
            }
            return 0.9375f;
        }
    };

    public void renderTileEntityAt(@Nonnull TileFaucet te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!te.isPouring || te.drained == null) {
            return;
        }
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        BlockPos below = pos.func_177977_b();
        IBlockState belowState = world.func_180495_p(below);
        float yMin = -depth.getDepth(world, below, belowState);
        if (te.direction == EnumFacing.UP) {
            RenderUtils.renderFluidCuboid(te.drained, te.func_174877_v(), x, y, z, 0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
            if (yMin < 0.0f) {
                RenderUtils.renderFluidCuboid(te.drained, te.func_174877_v(), x, y, z, 0.375, yMin, 0.375, 0.625, 0.0, 0.625);
            }
        } else if (te.direction.func_176736_b() >= 0) {
            IBlockState state = world.func_180495_p(pos);
            boolean connected = false;
            if (state.func_177230_c() instanceof BlockFaucet) {
                connected = (Boolean)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)BlockFaucet.CONNECTED);
            }
            float r = -90.0f * (float)(2 + te.direction.func_176736_b());
            float o = 0.5f;
            RenderUtils.pre(x, y, z);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer renderer = tessellator.func_178180_c();
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int color = te.drained.getFluid().getColor(te.drained);
            int brightness = te.func_145831_w().func_175626_b(te.func_174877_v(), te.drained.getFluid().getLuminosity());
            TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().getTextureExtry(te.drained.getFluid().getFlowing(te.drained).toString());
            GlStateManager.func_179109_b((float)o, (float)0.0f, (float)o);
            GlStateManager.func_179114_b((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)(-o), (float)0.0f, (float)(-o));
            double x1 = 0.375;
            double x2 = 0.625;
            double y1 = 0.375;
            double y2 = 0.625;
            double z1 = connected ? -0.0625 : 0.0;
            double z2 = 0.375;
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, true);
            y1 = 0.0;
            z1 = 0.375;
            z2 = 0.5;
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
            RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, true);
            if (yMin < 0.0f) {
                y1 = yMin;
                y2 = 0.0;
                RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, true);
                RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
                RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
                RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
                RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
            } else {
                RenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, true);
            }
            tessellator.func_78381_a();
            RenderUtils.post();
        }
    }

    private static interface IDepthGetter {
        public float getDepth(World var1, BlockPos var2, IBlockState var3);
    }
}

