/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import java.util.Locale;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.DispenseClayBucket;
import knightminer.ceramics.library.FluidClayBucketWrapper;
import knightminer.ceramics.library.Util;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemClayBucket
extends Item {
    public static final String TAG_FLUIDS = "fluids";
    public static ItemStack MILK_BUCKET = new ItemStack(Items.field_151117_aB);
    public static ItemStack BRICK = new ItemStack(Items.field_151118_aC);

    public ItemClayBucket() {
        this.func_77637_a(Ceramics.tab);
        this.field_77787_bX = true;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseClayBucket.getInstance());
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.hasFluid(stack)) {
            return 16;
        }
        return 1;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.hasSpecialFluid(stack)) {
            String specialFluid = this.getSpecialFluid(stack).getName();
            return I18n.func_74838_a((String)("item." + Util.prefix("clay_bucket." + specialFluid) + ".name"));
        }
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)("item." + Util.prefix("clay_bucket.empty") + ".name"));
        }
        String unloc = this.func_77657_g(stack);
        if (I18n.func_94522_b((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return I18n.func_74838_a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return I18n.func_74837_a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getSpecialFluid(stack) == SpecialFluid.MILK) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!this.hasFluid(stack)) {
            ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)this.func_77621_a(world, player, true));
            if (ret != null) {
                return ret;
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos clickPos = mop.func_178782_a();
        if (world.func_175660_a(player, clickPos)) {
            FluidStack fluidStack = this.getFluid(stack);
            IBlockState clickState = world.func_180495_p(clickPos);
            if (!player.func_70093_af() && clickState.func_177230_c() == Blocks.field_150383_bp) {
                ItemStack returnStack = stack.func_77946_l();
                if ((Integer)clickState.func_177229_b((IProperty)BlockCauldron.field_176591_a) < 3 && fluidStack.getFluid() == FluidRegistry.WATER) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        returnStack.func_190918_g(1);
                        ItemStack drained = new ItemStack((Item)this);
                        if (returnStack.func_190926_b()) {
                            returnStack = drained;
                        } else if (!drained.func_190926_b()) {
                            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)drained);
                        }
                    }
                    player.func_71029_a(StatList.field_188077_K);
                    if (!world.field_72995_K) {
                        Blocks.field_150383_bp.func_176590_a(world, clickPos, clickState, 3);
                    }
                    world.func_184133_a((EntityPlayer)null, clickPos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)returnStack);
            }
            if (player.func_175151_a(clickPos, mop.field_178784_b, stack)) {
                BlockPos targetPos = clickPos.func_177972_a(mop.field_178784_b);
                if (this.hasSpecialFluid(stack)) {
                    IBlockState currentState;
                    IBlockState state = this.getSpecialFluid(stack).getState();
                    if (state != null && (currentState = world.func_180495_p(targetPos)).func_177230_c().func_176200_f((IBlockAccess)world, targetPos)) {
                        if (!world.field_72995_K) {
                            world.func_175656_a(targetPos, state);
                        }
                        world.func_184133_a(player, targetPos, state.func_177230_c().getSoundType(state, world, targetPos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_71029_a(StatList.func_188057_b((Item)this));
                            this.setSpecialFluid(stack, SpecialFluid.EMPTY);
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                } else {
                    FluidActionResult result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)player.func_130014_f_(), (BlockPos)targetPos, (ItemStack)stack, (FluidStack)fluidStack);
                    if (result.isSuccess()) {
                        if (fluidStack.getFluid() == FluidRegistry.WATER || fluidStack.getFluid() == FluidRegistry.LAVA) {
                            IBlockState state = world.func_180495_p(targetPos);
                            world.func_190524_a(targetPos, state.func_177230_c(), targetPos);
                        }
                        ItemStack returnStack = stack.func_77946_l();
                        if (!player.field_71075_bZ.field_75098_d) {
                            returnStack.func_190918_g(1);
                            ItemStack drained = result.getResult().func_77946_l();
                            if (returnStack.func_190926_b()) {
                                returnStack = drained;
                            } else if (!drained.func_190926_b()) {
                                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)drained);
                            }
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)returnStack);
                    }
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket == null || !emptyBucket.func_77973_b().equals((Object)this)) {
            return;
        }
        ItemStack singleBucket = emptyBucket.func_77946_l();
        singleBucket.func_190920_e(1);
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        if (!(state.func_177230_c() != Blocks.field_150383_bp || player != null && player.func_70093_af())) {
            if ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 3) {
                event.setResult(Event.Result.ALLOW);
                event.setFilledBucket(this.withFluid(FluidRegistry.WATER));
                if (!world.field_72995_K) {
                    Blocks.field_150383_bp.func_176590_a(world, pos, state, 0);
                }
                if (player != null) {
                    SoundEvent soundevent = FluidRegistry.WATER.getFillSound(new FluidStack(FluidRegistry.WATER, 1000));
                    player.func_184185_a(soundevent, 1.0f, 1.0f);
                    player.func_71029_a(StatList.field_188078_L);
                }
            } else {
                event.setCanceled(true);
            }
            return;
        }
        FluidActionResult result = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (result.isSuccess()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(result.getResult());
        } else {
            SpecialFluid fluid = SpecialFluid.fromState(state);
            if (fluid != null) {
                event.setFilledBucket(this.setSpecialFluid(singleBucket, fluid));
                world.func_184133_a(player, pos, state.func_177230_c().getSoundType(state, world, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                if (!world.field_72995_K) {
                    world.func_175698_g(pos);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onItemDestroyed(PlayerDestroyItemEvent event) {
        ItemStack original = event.getOriginal();
        if (original.func_77973_b() == this) {
            event.getEntityPlayer().func_70669_a(BRICK);
        }
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.doesBreak(stack)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.doesBreak(stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!this.hasFluid(stack) && target instanceof EntityCow && !player.field_71075_bZ.field_75098_d) {
            if (stack.func_190916_E() > 1) {
                stack.func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.setSpecialFluid(new ItemStack((Item)this), SpecialFluid.MILK));
            } else {
                this.setSpecialFluid(stack, SpecialFluid.MILK);
            }
            return true;
        }
        return false;
    }

    public boolean doesBreak(ItemStack stack) {
        if (this.hasSpecialFluid(stack)) {
            return false;
        }
        FluidStack fluid = this.getFluid(stack);
        return fluid != null && fluid.getFluid().getTemperature() >= 450;
    }

    public boolean hasSpecialFluid(ItemStack stack) {
        return stack.func_77952_i() != 0;
    }

    public SpecialFluid getSpecialFluid(ItemStack stack) {
        return SpecialFluid.fromMeta(stack.func_77952_i());
    }

    public ItemStack setSpecialFluid(ItemStack stack, SpecialFluid fluid) {
        stack.func_77964_b(fluid.getMeta());
        return stack;
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.getSpecialFluid(container) == SpecialFluid.MILK) {
            return FluidRegistry.getFluidStack((String)"milk", (int)1000);
        }
        NBTTagCompound tags = container.func_77978_p();
        if (tags != null) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l(TAG_FLUIDS));
        }
        return null;
    }

    public boolean hasFluid(ItemStack container) {
        if (this.hasSpecialFluid(container)) {
            return true;
        }
        return this.getFluid(container) != null;
    }

    public int getCapacity() {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_190916_E() != 1) {
            return 0;
        }
        if (resource == null || resource.amount < this.getCapacity()) {
            return 0;
        }
        if (this.hasFluid(container)) {
            return 0;
        }
        if (resource.getFluid().getName().equals("milk")) {
            if (doFill) {
                this.setSpecialFluid(container, SpecialFluid.MILK);
            }
            return this.getCapacity();
        }
        if (FluidRegistry.getBucketFluids().contains(resource.getFluid()) || resource.getFluid() == FluidRegistry.WATER || resource.getFluid() == FluidRegistry.LAVA) {
            if (doFill) {
                NBTTagCompound tag = container.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74782_a(TAG_FLUIDS, (NBTBase)resource.writeToNBT(new NBTTagCompound()));
                container.func_77982_d(tag);
            }
            return this.getCapacity();
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_190916_E() != 1) {
            return null;
        }
        if (maxDrain < this.getCapacity()) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (doDrain && this.hasFluid(container)) {
            if (this.doesBreak(container)) {
                container.func_190920_e(0);
            } else if (this.getSpecialFluid(container) == SpecialFluid.MILK) {
                this.setSpecialFluid(container, SpecialFluid.EMPTY);
            } else if (!this.hasSpecialFluid(container)) {
                NBTTagCompound tag = container.func_77978_p();
                if (tag != null) {
                    tag.func_82580_o(TAG_FLUIDS);
                }
                if (tag.func_82582_d()) {
                    container.func_77982_d(null);
                }
            }
        }
        return fluidStack;
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.getSpecialFluid(stack) != SpecialFluid.MILK) {
            return stack;
        }
        if (entityLiving instanceof EntityPlayer && !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            this.setSpecialFluid(stack, SpecialFluid.EMPTY);
        }
        if (!worldIn.field_72995_K) {
            entityLiving.curePotionEffects(MILK_BUCKET);
        }
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_71029_a(StatList.func_188057_b((Item)this));
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getSpecialFluid(stack) == SpecialFluid.MILK ? 32 : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getSpecialFluid(stack) == SpecialFluid.MILK ? EnumAction.DRINK : EnumAction.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)new ItemStack((Item)this));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs;
            ItemStack stack;
            if (fluid.getName().equals("milk") || this.fill(stack = new ItemStack((Item)this), fs = new FluidStack(fluid, this.getCapacity()), true) != fs.amount) continue;
            subItems.add((Object)stack);
        }
        for (SpecialFluid fluid : SpecialFluid.values()) {
            if (!fluid.show()) continue;
            subItems.add((Object)new ItemStack((Item)this, 1, fluid.getMeta()));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidClayBucketWrapper(stack);
    }

    public ItemStack withFluid(Fluid fluid) {
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(TAG_FLUIDS, (NBTBase)new FluidStack(fluid, this.getCapacity()).writeToNBT(new NBTTagCompound()));
        stack.func_77982_d(tag);
        return stack;
    }

    public static enum SpecialFluid {
        EMPTY,
        MILK,
        SAND(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.SAND)),
        RED_SAND(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND)),
        GRAVEL(Blocks.field_150351_n.func_176223_P());

        private int meta = this.ordinal();
        private IBlockState state;

        private SpecialFluid() {
            this.state = null;
        }

        private SpecialFluid(IBlockState state) {
            this.state = state;
        }

        public String getName() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }

        public static SpecialFluid fromMeta(int meta) {
            if (meta < 0 || meta > SpecialFluid.values().length) {
                meta = 0;
            }
            return SpecialFluid.values()[meta];
        }

        public boolean show() {
            if (this.isBlock()) {
                return false;
            }
            return this != EMPTY;
        }

        public boolean isBlock() {
            return this.state != null;
        }

        public IBlockState getState() {
            return this.state;
        }

        @Nullable
        public static SpecialFluid fromState(IBlockState state) {
            if (!Config.bucketSand) {
                return null;
            }
            for (SpecialFluid fluid : SpecialFluid.values()) {
                if (!fluid.isBlock() || state != fluid.getState()) continue;
                return fluid;
            }
            return null;
        }
    }
}

