/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import java.util.Locale;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.Util;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemClayUnfired
extends Item {
    public ItemClayUnfired() {
        this.func_77637_a(Ceramics.tab);
        this.func_77627_a(true);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (UnfiredType type : UnfiredType.values()) {
            if (!type.shouldDisplay()) continue;
            subItems.add((Object)new ItemStack(itemIn, 1, type.getMeta()));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return UnfiredType.fromMeta(stack.func_77952_i()).getStackSize();
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + Util.prefix("unfired." + UnfiredType.fromMeta(stack.func_77952_i()).getName());
    }

    public static enum UnfiredType {
        BUCKET(16),
        SHEARS(1),
        BARREL,
        BARREL_EXTENSION,
        PORCELAIN,
        PORCELAIN_BRICK,
        BARREL_PORCELAIN,
        BARREL_PORCELAIN_EXTENSION,
        CLAY_PLATE_RAW,
        CLAY_PLATE;

        private int meta = this.ordinal();
        private int stackSize;

        private UnfiredType() {
            this.stackSize = 64;
        }

        private UnfiredType(int stackSize) {
            this.stackSize = stackSize;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean shouldDisplay() {
            switch (this) {
                case BUCKET: {
                    return Config.bucketEnabled && !Config.placeClayBucket;
                }
                case SHEARS: {
                    return Config.shearsEnabled;
                }
                case PORCELAIN: 
                case PORCELAIN_BRICK: {
                    return Config.porcelainEnabled;
                }
                case BARREL: 
                case BARREL_EXTENSION: 
                case BARREL_PORCELAIN: 
                case BARREL_PORCELAIN_EXTENSION: {
                    return false;
                }
                case CLAY_PLATE: 
                case CLAY_PLATE_RAW: {
                    return Config.armorEnabled;
                }
            }
            return true;
        }

        public int getStackSize() {
            return this.stackSize;
        }

        public static UnfiredType fromMeta(int meta) {
            if (meta < 0 || meta >= UnfiredType.values().length) {
                meta = 0;
            }
            return UnfiredType.values()[meta];
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

