/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.library;

import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.network.FluidUpdatePacket;
import knightminer.ceramics.tileentity.TileBarrel;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class BarrelTank
extends FluidTank {
    private TileBarrel parent;
    public int renderOffset;

    public BarrelTank(int capacity, TileBarrel parent) {
        super(capacity);
        this.parent = parent;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = super.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.sendUpdate(amount);
        }
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack fluid = super.drain(resource, doDrain);
        if (fluid != null && doDrain) {
            this.sendUpdate(-fluid.amount);
        }
        return fluid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fluid = super.drain(maxDrain, doDrain);
        if (fluid != null && doDrain) {
            this.sendUpdate(-fluid.amount);
        }
        return fluid;
    }

    protected void sendUpdate(int amount) {
        if (amount != 0) {
            this.renderOffset += amount;
            World world = this.parent.func_145831_w();
            if (!world.field_72995_K) {
                CeramicsNetwork.sendToAllAround(world, this.parent.func_174877_v(), new FluidUpdatePacket(this.parent.func_174877_v(), this.getFluid()));
            }
        }
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.fluid != null && this.fluid.amount > capacity) {
            this.drain(this.fluid.amount - capacity, true);
        }
        this.renderOffset = 0;
    }

    public void onContentsChanged() {
        this.parent.onTankContentsChanged();
    }
}

