/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.ceramics.items.BaseClayBucketItem;
import knightminer.ceramics.recipe.CeramicsTags;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MilkClayBucketItem
extends BaseClayBucketItem {
    private static final ItemStack MILK_STACK = new ItemStack((IItemProvider)Items.field_151117_aB);
    private static Fluid milk = null;

    public MilkClayBucketItem(boolean isCracked, Item.Properties props) {
        super(isCracked, props);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
        if (!worldIn.func_201670_d()) {
            entity.curePotionEffects(MILK_STACK);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entity;
            CriteriaTriggers.field_193138_y.func_193148_a(serverplayerentity, stack);
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (this.isCracked) {
                MilkClayBucketItem.renderBrokenItem(player, stack);
            }
            return MilkClayBucketItem.updateBucket(stack, player, stack.getContainerItem());
        }
        return stack;
    }

    @Nonnull
    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_211708_a(TextFormatting.RED);
    }

    @Override
    protected boolean hasFluid(ItemStack container) {
        return true;
    }

    @Override
    public Fluid getFluid(ItemStack stack) {
        if (milk != null) {
            return milk;
        }
        milk = CeramicsTags.Fluids.MILK.func_199885_a().isEmpty() ? Fluids.field_204541_a : (Fluid)CeramicsTags.Fluids.MILK.func_205596_a(field_77697_d);
        return milk;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab) && !this.isCracked) {
            subItems.add((Object)new ItemStack((IItemProvider)this));
        }
    }
}

