/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.registration;

import java.util.EnumMap;
import java.util.function.Function;
import java.util.function.Supplier;
import knightminer.ceramics.registration.BlockItemObject;
import knightminer.ceramics.registration.BuildingBlockObject;
import knightminer.ceramics.registration.EnumBlockObject;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockDeferredRegister {
    private final DeferredRegister<Block> blockRegistry;
    private final DeferredRegister<Item> itemRegistry;

    public BlockDeferredRegister(String modID) {
        this.blockRegistry = new DeferredRegister(ForgeRegistries.BLOCKS, modID);
        this.itemRegistry = new DeferredRegister(ForgeRegistries.ITEMS, modID);
    }

    public void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.blockRegistry.register(bus);
        this.itemRegistry.register(bus);
    }

    public <B extends Block> RegistryObject<B> register(String name, Supplier<? extends B> block) {
        return this.blockRegistry.register(name, block);
    }

    public RegistryObject<Block> register(String name, Block.Properties props) {
        return this.register(name, () -> new Block(props));
    }

    public <B extends Block, I extends BlockItem> BlockItemObject<B, I> register(String name, Supplier<? extends B> block, Function<? super B, ? extends I> item) {
        RegistryObject blockObj = this.register(name, block);
        return new BlockItemObject(blockObj, this.itemRegistry.register(name, () -> (BlockItem)item.apply((Object)blockObj.get())));
    }

    public <B extends Block> BlockItemObject<B, BlockItem> register(String name, Supplier<? extends B> block, Item.Properties props) {
        return this.register(name, block, (? super B b) -> new BlockItem(b, props));
    }

    public BlockItemObject<Block, BlockItem> register(String name, Block.Properties blockProps, Item.Properties itemProps) {
        return this.register(name, () -> new Block(blockProps), itemProps);
    }

    public BuildingBlockObject registerBuilding(String name, Block.Properties props, Item.Properties itemProps) {
        BlockItemObject<Block, BlockItem> blockObj = this.register(name, props, itemProps);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(props), itemProps), this.register(name + "_stairs", () -> new StairsBlock(() -> blockObj.get().func_176223_P(), props), itemProps), this.register(name + "_wall", () -> new WallBlock(props), itemProps));
    }

    public <T extends Enum<T>, B extends Block> EnumBlockObject<T, B> registerEnum(T[] values, String name, Function<T, ? extends B> supplier, Item.Properties itemProps) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have at least one value");
        }
        EnumMap map = new EnumMap(values[0].getClass());
        for (Object value : values) {
            map.put(value, this.register(((Enum)value).toString() + "_" + name, () -> (Block)supplier.apply(value), itemProps));
        }
        return new EnumBlockObject(map);
    }
}

