/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CoreConstants {
    public static final String MODID = "d3core";
    public static final String NAME = "D\u00b3 Core";
    public static final String BASE_URL = "http://doubledoordev.net/";
    public static final String PERKS_URL = "http://doubledoordev.net/perks.json";
    public static final String UPDATE_URL = "http://doubledoordev.net/d3core.json";
    public static final String MOD_GUI_FACTORY = "net.doubledoordev.d3core.client.ModConfigGuiFactory";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Random RANDOM = new Random();
    public static final String LOGIN_MESSAGE_FILE = "loginmessage.txt";
    public static final Pattern PATTERN_ITEMSTACK = Pattern.compile("^(?:(?<mod>.*):)?(?<name>.*?) ?(?<meta>\\*|\\d+)? ?(?<stacksize>\\d+)?$");

    public static void spawnRandomFireworks(Entity target, int rad, int rockets) {
        while (rockets-- > 0) {
            ItemStack itemStack = new ItemStack(Items.field_151152_bP);
            NBTTagCompound fireworks = new NBTTagCompound();
            NBTTagList explosions = new NBTTagList();
            int charges = 1 + RANDOM.nextInt(3);
            while (charges-- > 0) {
                NBTTagCompound explosion = new NBTTagCompound();
                if (RANDOM.nextBoolean()) {
                    explosion.func_74757_a("Flicker", true);
                }
                if (RANDOM.nextBoolean()) {
                    explosion.func_74757_a("Trail", true);
                }
                int[] colors = new int[1 + RANDOM.nextInt(3)];
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = (RANDOM.nextInt(256) << 16) + (RANDOM.nextInt(256) << 8) + RANDOM.nextInt(256);
                }
                explosion.func_74783_a("Colors", colors);
                explosion.func_74774_a("Type", (byte)RANDOM.nextInt(5));
                if (RANDOM.nextBoolean()) {
                    int[] fadeColors = new int[1 + RANDOM.nextInt(3)];
                    for (int i = 0; i < fadeColors.length; ++i) {
                        fadeColors[i] = (RANDOM.nextInt(256) << 16) + (RANDOM.nextInt(256) << 8) + RANDOM.nextInt(256);
                    }
                    explosion.func_74783_a("FadeColors", fadeColors);
                }
                explosions.func_74742_a((NBTBase)explosion);
            }
            fireworks.func_74782_a("Explosions", (NBTBase)explosions);
            fireworks.func_74774_a("Flight", (byte)RANDOM.nextInt(2));
            NBTTagCompound root = new NBTTagCompound();
            root.func_74782_a("Fireworks", (NBTBase)fireworks);
            itemStack.func_77982_d(root);
            target.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(target.field_70170_p, target.field_70165_t + (double)RANDOM.nextInt(rad) - (double)rad / 2.0, target.field_70163_u, target.field_70161_v + (double)RANDOM.nextInt(rad) - (double)rad / 2.0, itemStack));
        }
    }
}

