/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URL;
import java.nio.charset.Charset;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.util.CoreConstants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.IOUtils;

public class DevPerks {
    private JsonObject perks = new JsonObject();

    public DevPerks() {
        this.update();
    }

    private void update() {
        block3: {
            try {
                this.perks = new JsonParser().parse(IOUtils.toString((URL)new URL("http://doubledoordev.net/perks.json"), (Charset)Charset.forName("UTF-8"))).getAsJsonObject();
            }
            catch (Exception e) {
                D3Core.getLogger().warn("There may be an error in devperks, no sillyness for you...", (Throwable)e);
                if (!D3Core.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        if (this.perks == null) {
            this.perks = new JsonObject();
        }
    }

    private static ItemStack getItemStackFromJson(JsonObject data, int defaultMeta, int defaultStacksize) {
        NBTTagCompound display;
        NBTTagCompound root;
        int meta = data.has("meta") ? data.get("meta").getAsInt() : defaultMeta;
        int size = data.has("size") ? data.get("size").getAsInt() : defaultStacksize;
        ItemStack stack = GameRegistry.makeItemStack((String)data.get("name").getAsString(), (int)size, (int)meta, null);
        if (stack == ItemStack.field_190927_a) {
            return null;
        }
        if (data.has("display")) {
            stack.func_151001_c(data.get("display").getAsString());
        }
        if (data.has("color")) {
            root = stack.func_77978_p();
            if (root == null) {
                root = new NBTTagCompound();
            }
            display = root.func_74775_l("display");
            display.func_74768_a("color", data.get("color").getAsInt());
            root.func_74782_a("display", (NBTBase)display);
            stack.func_77982_d(root);
        }
        if (data.has("lore")) {
            root = stack.func_77978_p();
            if (root == null) {
                root = new NBTTagCompound();
            }
            display = root.func_74775_l("display");
            NBTTagList lore = new NBTTagList();
            for (JsonElement element : data.getAsJsonArray("lore")) {
                lore.func_74742_a((NBTBase)new NBTTagString(element.getAsString()));
            }
            display.func_74782_a("Lore", (NBTBase)lore);
            root.func_74782_a("display", (NBTBase)display);
            stack.func_77982_d(root);
        }
        return stack;
    }

    @SubscribeEvent
    public void nameFormatEvent(PlayerEvent.NameFormat event) {
        block5: {
            try {
                if (D3Core.isDebug()) {
                    this.update();
                }
                if (this.perks.has(event.getUsername())) {
                    JsonObject perk = this.perks.getAsJsonObject(event.getUsername());
                    if (perk.has("displayname")) {
                        event.setDisplayname(perk.get("displayname").getAsString());
                    }
                    this.doHat(perk, event.getEntityPlayer());
                }
            }
            catch (Exception e) {
                if (!D3Core.isDebug()) break block5;
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        block4: {
            try {
                JsonObject fw;
                JsonObject perk;
                if (D3Core.isDebug()) {
                    this.update();
                }
                if (this.perks.has(event.player.func_70005_c_()) && (perk = this.perks.getAsJsonObject(event.player.func_70005_c_())).has("fireworks") && (fw = perk.getAsJsonObject("fireworks")).has("login")) {
                    JsonObject obj = fw.getAsJsonObject("login");
                    int rad = obj.has("radius") ? obj.get("radius").getAsInt() : 5;
                    int rockets = obj.has("rockets") ? obj.get("rockets").getAsInt() : 5;
                    CoreConstants.spawnRandomFireworks((Entity)event.player, rad + CoreConstants.RANDOM.nextInt(rad), rockets + CoreConstants.RANDOM.nextInt(rockets));
                }
            }
            catch (Exception e) {
                if (!D3Core.isDebug()) break block4;
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void achievementEvent(AchievementEvent event) {
        block5: {
            StatisticsManagerServer sms;
            EntityPlayer player = event.getEntityPlayer();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player.func_184102_h() != null && (sms = player.func_184102_h().func_184103_al().func_152602_a(player)).func_77442_b(event.getAchievement()) && !sms.func_77443_a(event.getAchievement())) {
                try {
                    JsonObject fw;
                    JsonObject perk;
                    if (D3Core.isDebug()) {
                        this.update();
                    }
                    if (this.perks.has(player.func_70005_c_()) && (perk = this.perks.getAsJsonObject(player.func_70005_c_())).has("fireworks") && (fw = perk.getAsJsonObject("fireworks")).has("achievement")) {
                        JsonObject obj = fw.getAsJsonObject("achievement");
                        int rad = obj.has("radius") ? obj.get("radius").getAsInt() : 5;
                        int rockets = obj.has("rockets") ? obj.get("rockets").getAsInt() : 5;
                        CoreConstants.spawnRandomFireworks((Entity)player, rad + CoreConstants.RANDOM.nextInt(rad), rockets + CoreConstants.RANDOM.nextInt(rockets));
                    }
                }
                catch (Exception e) {
                    if (!D3Core.isDebug()) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void cloneEvent(PlayerEvent.Clone event) {
        block4: {
            try {
                if (D3Core.isDebug()) {
                    this.update();
                }
                if (this.perks.has(event.getOriginal().func_70005_c_())) {
                    JsonObject perk = this.perks.getAsJsonObject(event.getOriginal().func_70005_c_());
                    this.doHat(perk, event.getEntityPlayer());
                }
            }
            catch (Exception e) {
                if (!D3Core.isDebug()) break block4;
                e.printStackTrace();
            }
        }
    }

    private void doHat(JsonObject perk, EntityPlayer player) {
        if (perk.has("hat") && (player.func_184582_a(EntityEquipmentSlot.HEAD) == ItemStack.field_190927_a || player.func_184582_a(EntityEquipmentSlot.HEAD).func_190916_E() == 0)) {
            ItemStack hat = DevPerks.getItemStackFromJson(perk.getAsJsonObject("hat"), 0, 0);
            if (hat == ItemStack.field_190927_a) {
                return;
            }
            hat.func_190920_e(0);
            player.func_184201_a(EntityEquipmentSlot.HEAD, hat);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void deathEvent(PlayerDropsEvent event) {
        block5: {
            try {
                JsonObject perk;
                if (D3Core.isDebug()) {
                    this.perks = new JsonParser().parse(IOUtils.toString((URL)new URL("http://doubledoordev.net/perks.json"), (Charset)Charset.forName("UTF-8"))).getAsJsonObject();
                }
                if (this.perks.has(event.getEntityPlayer().func_70005_c_()) && (perk = this.perks.getAsJsonObject(event.getEntityPlayer().func_70005_c_())).has("drop")) {
                    ItemStack stack = DevPerks.getItemStackFromJson(perk.getAsJsonObject("drop"), 0, 1);
                    if (stack == ItemStack.field_190927_a) {
                        return;
                    }
                    event.getDrops().add(new EntityItem(event.getEntityPlayer().func_130014_f_(), event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, stack));
                }
            }
            catch (Exception e) {
                if (!D3Core.isDebug()) break block5;
                e.printStackTrace();
            }
        }
    }

    public void update(boolean silliness) {
        block4: {
            try {
                if (silliness) {
                    MinecraftForge.EVENT_BUS.register((Object)this);
                } else {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
            }
            catch (Exception e) {
                if (!D3Core.isDebug()) break block4;
                e.printStackTrace();
            }
        }
    }
}

