/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.util.CoreConstants;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class Materials {
    public static void load() throws IOException {
        File file = new File(D3Core.getFolder(), "materials.json");
        if (!file.exists()) {
            return;
        }
        Map stringMap = (Map)CoreConstants.GSON.fromJson(FileUtils.readFileToString((File)file, (String)"utf-8"), Map.class);
        HashMap<String, ItemStack> itemStackMap = new HashMap<String, ItemStack>(stringMap.size());
        boolean stop = false;
        for (Map.Entry entry : stringMap.entrySet()) {
            Item item;
            Matcher matcher = CoreConstants.PATTERN_ITEMSTACK.matcher((CharSequence)entry.getValue());
            if (!matcher.matches()) {
                D3Core.getLogger().error("Entry in materials.json does not match a valid ItemStack text: {}.", new Object[]{entry});
                stop = true;
                continue;
            }
            String mod = matcher.group("mod");
            String name = matcher.group("name");
            String metaString = matcher.group("meta");
            String stacksizeString = matcher.group("stacksize");
            if (Strings.isNullOrEmpty((String)mod)) {
                mod = "minecraft";
            }
            if (!Loader.isModLoaded((String)mod)) {
                D3Core.getLogger().warn("Skipped materials.json entry {} because mod {} is not loaded.", new Object[]{entry, mod});
                continue;
            }
            int meta = Short.MAX_VALUE;
            int stacksize = 1;
            if (!Strings.isNullOrEmpty((String)metaString) && !metaString.equals("*")) {
                meta = Integer.parseInt(metaString);
            }
            if (!Strings.isNullOrEmpty((String)stacksizeString)) {
                stacksize = Integer.parseInt(stacksizeString);
            }
            if ((item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, name))) == null) {
                D3Core.getLogger().error("Entry in materials.json {} invalid. Item {}:{} does not exist.", new Object[]{entry, mod, name});
                stop = true;
                continue;
            }
            ItemStack stack = new ItemStack(item, stacksize, meta);
            itemStackMap.put(((String)entry.getKey()).toLowerCase(), stack);
        }
        if (stop) {
            D3Core.getLogger().error("The proper format for materials.json entries is (in regex): {}", new Object[]{CoreConstants.PATTERN_ITEMSTACK.pattern()});
            RuntimeException e = new RuntimeException("You have invalid entries in your materials.json file. Check the log for more info.");
            e.setStackTrace(new StackTraceElement[0]);
            throw e;
        }
        for (Item.ToolMaterial material : Item.ToolMaterial.values()) {
            ItemStack stack = (ItemStack)itemStackMap.get(material.name().toLowerCase());
            if (stack == ItemStack.field_190927_a) continue;
            material.setRepairItem(stack);
        }
    }
}

