/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.doubledoordev.d3core.permissions.PermissionsDB;
import net.doubledoordev.d3core.permissions.cmd.CommandGroup;
import net.doubledoordev.d3core.util.CoreHelper;
import net.doubledoordev.d3core.util.DevPerks;
import net.doubledoordev.d3core.util.EndermanGriefing;
import net.doubledoordev.d3core.util.FMLEventHandler;
import net.doubledoordev.d3core.util.ForgeEventHandler;
import net.doubledoordev.d3core.util.ID3Mod;
import net.doubledoordev.d3core.util.libs.org.mcstats.Metrics;
import net.minecraft.command.ICommand;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Mod(modid="D3Core", name="D\u00b3 Core", canBeDeactivated=false, guiFactory="net.doubledoordev.d3core.client.ModConfigGuiFactory")
public class D3Core
implements ID3Mod {
    @Mod.Instance(value="D3Core")
    public static D3Core instance;
    private File folder;
    @Mod.Metadata
    private ModMetadata metadata;
    private Logger logger;
    private DevPerks devPerks;
    private Configuration configuration;
    private boolean debug = false;
    private boolean sillyness = true;
    private boolean updateWarning = true;
    private List<ModContainer> d3Mods = new ArrayList<ModContainer>();
    private List<CoreHelper.ModUpdateDate> updateDateList = new ArrayList<CoreHelper.ModUpdateDate>();
    private boolean pastPost;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)FMLEventHandler.FML_EVENT_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)ForgeEventHandler.FORGE_EVENT_HANDLER);
        this.logger = event.getModLog();
        this.folder = new File(event.getModConfigurationDirectory(), "D3Core");
        this.folder.mkdir();
        File configFile = new File(this.folder, event.getSuggestedConfigurationFile().getName());
        if (event.getSuggestedConfigurationFile().exists()) {
            try {
                FileUtils.copyFile((File)event.getSuggestedConfigurationFile(), (File)configFile);
                event.getSuggestedConfigurationFile().delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.configuration = new Configuration(configFile);
        this.syncConfig();
        PermissionsDB.load();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        for (final ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (!(modContainer instanceof FMLModContainer) || !(modContainer.getMod() instanceof ID3Mod)) continue;
            if (D3Core.debug()) {
                this.logger.info(String.format("[%s] Found a D3 Mod!", modContainer.getModId()));
            }
            this.d3Mods.add(modContainer);
            if (!this.updateWarning) continue;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TreeSet<DefaultArtifactVersion> availableVersions = new TreeSet<DefaultArtifactVersion>();
                        String group = modContainer.getMod().getClass().getPackage().getName();
                        String artifactId = modContainer.getName();
                        if (D3Core.debug()) {
                            D3Core.this.logger.info(String.format("[%s] Group: %s ArtifactId: %s", modContainer.getModId(), group, artifactId));
                        }
                        URL url = new URL("http://doubledoordev.net/maven/" + group.replace('.', '/') + '/' + artifactId + "/maven-metadata.xml");
                        if (D3Core.debug()) {
                            D3Core.this.logger.info(String.format("[%s] Maven URL: %s", modContainer.getModId(), url));
                        }
                        DocumentBuilder builder = dbf.newDocumentBuilder();
                        Document document = builder.parse(url.toURI().toString());
                        NodeList list = document.getDocumentElement().getElementsByTagName("version");
                        for (int i = 0; i < list.getLength(); ++i) {
                            String version = list.item(i).getFirstChild().getNodeValue();
                            if (!version.startsWith("1.7.10-")) continue;
                            availableVersions.add(new DefaultArtifactVersion(version.replace("1.7.10-", "")));
                        }
                        DefaultArtifactVersion current = new DefaultArtifactVersion(modContainer.getVersion().replace("1.7.10-", ""));
                        if (D3Core.debug()) {
                            D3Core.this.logger.info(String.format("[%s] Current: %s Latest: %s All versions for MC %s: %s", modContainer.getModId(), current, availableVersions.last(), "1.7.10", availableVersions));
                        }
                        if (current.compareTo((ArtifactVersion)availableVersions.last()) < 0) {
                            D3Core.this.updateDateList.add(new CoreHelper.ModUpdateDate(modContainer.getName(), modContainer.getModId(), current.toString(), ((ArtifactVersion)availableVersions.last()).toString()));
                        }
                    }
                    catch (Exception e) {
                        D3Core.this.logger.info("D3 Mod " + modContainer.getModId() + " Version check FAILED. Error: " + e.toString());
                    }
                }
            }).start();
        }
        try {
            Metrics metrics = new Metrics("D3Core", this.metadata.version);
            Metrics.Graph submods = metrics.createGraph("Submods");
            for (ModContainer modContainer : this.d3Mods) {
                submods.addPlotter(new Metrics.Plotter(modContainer.getModId()){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
            }
            for (ModContainer modContainer : this.d3Mods) {
                metrics.createGraph(modContainer.getModId()).addPlotter(new Metrics.Plotter(modContainer.getDisplayVersion()){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
            }
            metrics.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (CoreHelper.ModUpdateDate updateDate : this.updateDateList) {
            this.logger.warn(String.format("Update available for %s (%s)! Current version: %s New version: %s. Please update ASAP!", updateDate.getName(), updateDate.getModId(), updateDate.getCurrentVersion(), updateDate.getLatestVersion()));
        }
        EndermanGriefing.init();
        this.pastPost = true;
        PermissionsDB.save();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandGroup());
    }

    @SubscribeEvent
    public void nameFormatEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.updateWarning || this.updateDateList.isEmpty()) {
            return;
        }
        event.player.func_146105_b(IChatComponent.Serializer.func_150699_a((String)"{\"text\":\"\",\"extra\":[{\"text\":\"Updates available for these mods:\",\"color\":\"gold\"}]}"));
        for (CoreHelper.ModUpdateDate updateDate : this.updateDateList) {
            event.player.func_146105_b(IChatComponent.Serializer.func_150699_a((String)String.format("{\"text\":\"\",\"extra\":[{\"text\":\"%s: %s -> %s\"}]}", updateDate.getName(), updateDate.getCurrentVersion(), updateDate.getLatestVersion())));
        }
        event.player.func_146105_b(IChatComponent.Serializer.func_150699_a((String)"{\"text\":\"\",\"extra\":[{\"text\":\"Download here!\",\"color\":\"gold\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"http://doubledoordev.net\"}},{\"text\":\" <- That is a link btw :p\"}]}"));
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (!(modContainer.getMod() instanceof ID3Mod)) continue;
            ((ID3Mod)modContainer.getMod()).syncConfig();
        }
    }

    @Override
    public void syncConfig() {
        this.configuration.setCategoryLanguageKey("D3Core", "d3.core.config.core").setCategoryComment("D3Core", LanguageRegistry.instance().getStringLocalization("d3.core.config.core"));
        this.debug = this.configuration.getBoolean("debug", "D3Core", this.debug, "Enable debug mode", "d3.core.config.debug");
        this.sillyness = this.configuration.getBoolean("sillyness", "D3Core", this.sillyness, "Enable sillyness\nBut seriously, you can disable name changes, drops and block helmets with this setting.", "d3.core.config.sillyness");
        this.updateWarning = this.configuration.getBoolean("updateWarning", "D3Core", this.updateWarning, "Allow update warnings on login", "d3.core.config.updateWarning");
        FMLEventHandler.FML_EVENT_HANDLER.norain = this.configuration.getBoolean("norain", "D3Core", FMLEventHandler.FML_EVENT_HANDLER.norain, "No more rain if set to true.", "d3.core.config.norain");
        FMLEventHandler.FML_EVENT_HANDLER.insomnia = this.configuration.getBoolean("insomnia", "D3Core", FMLEventHandler.FML_EVENT_HANDLER.insomnia, "No more daytime when players sleep if set to true.", "d3.core.config.insomnia");
        ForgeEventHandler.FORGE_EVENT_HANDLER.nosleep = this.configuration.getBoolean("nosleep", "D3Core", ForgeEventHandler.FORGE_EVENT_HANDLER.nosleep, "No sleep at all", "d3.core.config.nosleep");
        D3Core.getDevPerks().update(this.sillyness);
        String catTooltips = "D3Core.tooltips";
        this.configuration.setCategoryLanguageKey("D3Core.tooltips", "d3.core.config.tooltips").addCustomCategoryComment("D3Core.tooltips", LanguageRegistry.instance().getStringLocalization("d3.core.config.tooltips"));
        ForgeEventHandler.FORGE_EVENT_HANDLER.enableStringID = this.configuration.getBoolean("enableStringID", "D3Core.tooltips", true, "Example: minecraft:gold_ore", "d3.core.config.tooltips.enableStringID");
        ForgeEventHandler.FORGE_EVENT_HANDLER.enableUnlocalizedName = this.configuration.getBoolean("enableUnlocalizedName", "D3Core.tooltips", true, "Example: tile.oreGold", "d3.core.config.tooltips.enableUnlocalizedName");
        ForgeEventHandler.FORGE_EVENT_HANDLER.enableOreDictionary = this.configuration.getBoolean("enableOreDictionary", "D3Core.tooltips", true, "Example: oreGold", "d3.core.config.tooltips.enableOreDictionary");
        String catEnderGriefing = "D3Core.EndermanGriefing";
        this.configuration.setCategoryLanguageKey("D3Core.EndermanGriefing", "d3.core.config.EndermanGriefing");
        EndermanGriefing.undo();
        EndermanGriefing.disable = this.configuration.getBoolean("disable", "D3Core.EndermanGriefing", false, "Disable Enderman griefing completely.", "d3.core.config.EndermanGriefing.disable");
        EndermanGriefing.dropCarrying = this.configuration.getBoolean("dropCarrying", "D3Core.EndermanGriefing", false, "Made Enderman drop there carrying block on death.", "d3.core.config.EndermanGriefing.dropCarrying");
        Property property = this.configuration.get("D3Core.EndermanGriefing", "blacklist", new String[0], "List of blocks (minecraft:stone) that will never be allowed to be picked up.");
        property.setLanguageKey("d3.core.config.EndermanGriefing.blacklist");
        EndermanGriefing.blacklist = property.getStringList();
        property = this.configuration.get("D3Core.EndermanGriefing", "addlist", new String[0], "List of blocks (minecraft:stone) that will be added to the list of blocks Enderman pick up.");
        property.setLanguageKey("d3.core.config.EndermanGriefing.addlist");
        EndermanGriefing.addList = property.getStringList();
        if (this.pastPost) {
            EndermanGriefing.init();
        }
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    @Override
    public void addConfigElements(List<IConfigElement> list) {
        list.add((IConfigElement)new ConfigElement(this.configuration.getCategory("D3Core".toLowerCase())));
    }

    public static Logger getLogger() {
        return D3Core.instance.logger;
    }

    public static boolean debug() {
        return D3Core.instance.debug;
    }

    public static Configuration getConfiguration() {
        return D3Core.instance.configuration;
    }

    public static DevPerks getDevPerks() {
        if (D3Core.instance.devPerks == null) {
            D3Core.instance.devPerks = new DevPerks();
        }
        return D3Core.instance.devPerks;
    }

    public static File getFolder() {
        return D3Core.instance.folder;
    }
}

