/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.permissions;

import java.util.HashSet;
import net.doubledoordev.d3core.permissions.Node;
import net.doubledoordev.d3core.permissions.PermissionsDB;

public class Group {
    private HashSet<Node> nodes = new HashSet();
    private String name;
    private String parent;

    public Group() {
    }

    public Group(String name) {
        this.name = name;
    }

    public Group(String name, String parent) {
        this.name = name;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean hasPermissionFor(Node requestNode) {
        if (this.parent != null && PermissionsDB.INSTANCE.getGroup(this.parent).hasPermissionFor(requestNode)) {
            return true;
        }
        for (Node hadNode : this.nodes) {
            if (!hadNode.matches(requestNode)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = this.nodes.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.parent.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return this.name.equals(group.name) && this.nodes.equals(group.nodes) && this.parent.equals(group.parent);
    }

    public void addNode(String nodeString) {
        this.nodes.add(new Node(nodeString));
    }

    public boolean removeNode(String nodeString) {
        return this.nodes.remove(new Node(nodeString));
    }

    public HashSet<String> getNodes() {
        HashSet<String> strings = new HashSet<String>();
        for (Node node : this.nodes) {
            strings.add(node.toString());
        }
        return strings;
    }
}

