/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.permissions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.doubledoordev.d3core.util.CoreConstants;
import org.apache.commons.lang3.ArrayUtils;

public class Node {
    final String[] parts;

    public Node(String parts) {
        this.parts = parts.toLowerCase().split("\\.");
    }

    public Node(String ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].toLowerCase();
        }
        this.parts = parts;
    }

    public boolean matches(Node requestNode) {
        if (this.equals(requestNode)) {
            return true;
        }
        for (int i = 0; i < this.parts.length && i < requestNode.parts.length; ++i) {
            if (this.parts[i].equals("*")) {
                return true;
            }
            if (this.parts[i].equals(requestNode.parts[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Arrays.equals(this.parts, node.parts);
    }

    public String toString() {
        return CoreConstants.JOINER_DOT.join((Object[])this.parts);
    }

    public Node append(String ... extras) {
        return new Node((String[])ArrayUtils.addAll((Object[])this.parts, (Object[])extras));
    }

    public static class JsonHelper
    implements JsonSerializer<Node>,
    JsonDeserializer<Node> {
        public Node deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Node((String)context.deserialize(json, String.class));
        }

        public JsonElement serialize(Node src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.toString());
        }
    }
}

