/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.permissions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.doubledoordev.d3core.D3Core;
import net.doubledoordev.d3core.permissions.Group;
import net.doubledoordev.d3core.permissions.Node;
import net.doubledoordev.d3core.permissions.Player;
import net.doubledoordev.d3core.util.CoreConstants;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;

public class PermissionsDB {
    public static final PermissionsDB INSTANCE = new PermissionsDB();
    private HashMap<UUID, Player> playerDB = new HashMap();
    private HashMap<String, Group> groupDB = new HashMap();

    private PermissionsDB() {
    }

    public static void load() {
        try {
            PermissionsDB.INSTANCE.playerDB.clear();
            if (PermissionsDB.getPlayersFile().exists()) {
                PermissionsDB.INSTANCE.playerDB.putAll((Map)CoreConstants.GSON.fromJson(FileUtils.readFileToString((File)PermissionsDB.getPlayersFile()), HashMap.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            PermissionsDB.INSTANCE.groupDB.clear();
            if (PermissionsDB.getGroupsFile().exists()) {
                PermissionsDB.INSTANCE.groupDB.putAll((Map)CoreConstants.GSON.fromJson(FileUtils.readFileToString((File)PermissionsDB.getGroupsFile()), HashMap.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            FileUtils.writeStringToFile((File)PermissionsDB.getPlayersFile(), (String)CoreConstants.GSON.toJson(PermissionsDB.INSTANCE.playerDB));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FileUtils.writeStringToFile((File)PermissionsDB.getGroupsFile(), (String)CoreConstants.GSON.toJson(PermissionsDB.INSTANCE.groupDB));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getGroupsFile() {
        return new File(D3Core.getFolder(), "Groups.json");
    }

    public static File getPlayersFile() {
        return new File(D3Core.getFolder(), "Players.json");
    }

    public Group getGroup(String parent) {
        if (this.groupDB.containsKey(parent = parent.toLowerCase())) {
            this.groupDB.put(parent, new Group(parent));
        }
        return this.groupDB.get(parent);
    }

    public Player getPlayer(UUID uuid) {
        if (!this.playerDB.containsKey(uuid)) {
            this.playerDB.put(uuid, new Player(uuid));
        }
        return this.playerDB.get(uuid);
    }

    public Collection<Group> getGroups() {
        return this.groupDB.values();
    }

    public Collection<Player> getPlayers() {
        return this.playerDB.values();
    }

    public boolean checkPermissions(ICommandSender sender, Node node) {
        if (sender.func_70005_c_().equals(MinecraftServer.func_71276_C().func_71214_G())) {
            return true;
        }
        if (sender == MinecraftServer.func_71276_C()) {
            return true;
        }
        if (sender == RConConsoleSource.field_70010_a) {
            return true;
        }
        if (sender instanceof EntityPlayer) {
            return this.checkPermissions(((EntityPlayer)sender).func_146103_bH().getId(), node);
        }
        D3Core.getLogger().warn("checkPermissions: " + sender.func_70005_c_());
        return false;
    }

    public boolean checkPermissions(UUID uuid, Node node) {
        Player player = this.getPlayer(uuid);
        for (Node node2 : player.getNodes()) {
            if (!node2.matches(node)) continue;
            return true;
        }
        for (String string : player.getGroups()) {
            if (!this.getGroup(string).hasPermissionFor(node)) continue;
            return true;
        }
        return false;
    }
}

