/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.permissions;

import java.util.HashSet;
import java.util.UUID;
import net.doubledoordev.d3core.permissions.Node;

public class Player {
    private HashSet<String> groups = new HashSet();
    private HashSet<Node> overrideNodes = new HashSet();
    private UUID uuid;

    public Player() {
    }

    public Player(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Iterable<? extends String> getGroups() {
        return this.groups;
    }

    public boolean removeGroup(String group) {
        return this.groups.remove(group.toLowerCase());
    }

    public void addGroup(String groupName) {
        this.groups.add(groupName.toLowerCase());
    }

    public int hashCode() {
        int result = this.groups.hashCode();
        result = 31 * result + this.overrideNodes.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        return this.groups.equals(player.groups) && this.uuid.equals(player.uuid) && this.overrideNodes.equals(player.overrideNodes);
    }

    public void addNode(Node node) {
        this.overrideNodes.add(node);
    }

    public boolean removeNode(Node node) {
        return this.overrideNodes.remove(node);
    }

    public HashSet<Node> getNodes() {
        return this.overrideNodes;
    }
}

