/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.util;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.doubledoordev.d3core.D3Core;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityEnderman;

public class EndermanGriefing {
    public static boolean disable;
    public static boolean dropCarrying;
    public static String[] blacklist;
    public static String[] addList;
    private static HashMap<String, Boolean> reverseMap;

    public static void init() {
        if (disable) {
            FMLControlledNamespacedRegistry blockData = GameData.getBlockRegistry();
            for (Object key : blockData.func_148742_b()) {
                Block block = (Block)blockData.func_82594_a(key);
                reverseMap.put(blockData.func_148750_c((Object)block), EntityEnderman.getCarriable((Block)block));
                EntityEnderman.setCarriable((Block)block, (boolean)false);
            }
        } else {
            List<Block> blocks;
            int added = 0;
            int removed = 0;
            for (String item : addList) {
                blocks = EndermanGriefing.matchBlock(item);
                if (blocks.isEmpty()) {
                    D3Core.getLogger().warn("[EndermanGriefing]  '{}' does not match any block...", new Object[]{item});
                    continue;
                }
                for (Block block : blocks) {
                    reverseMap.put(item, EntityEnderman.getCarriable((Block)block));
                    EntityEnderman.setCarriable((Block)block, (boolean)true);
                    ++added;
                }
            }
            for (String item : blacklist) {
                blocks = EndermanGriefing.matchBlock(item);
                if (blocks.isEmpty()) {
                    D3Core.getLogger().warn("[EndermanGriefing] '{}' does not match any block...", new Object[]{item});
                    continue;
                }
                for (Block block : blocks) {
                    reverseMap.put(item, EntityEnderman.getCarriable((Block)block));
                    EntityEnderman.setCarriable((Block)block, (boolean)false);
                    ++removed;
                }
            }
            D3Core.getLogger().info("[EndermanGriefing] Added {} and removed {} blocks to the Ederman grab list...", new Object[]{added, removed});
        }
    }

    private static List<Block> matchBlock(String item) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Pattern pattern = Pattern.compile(item.replace("*", ".*?"));
        FMLControlledNamespacedRegistry blockData = GameData.getBlockRegistry();
        for (Block block : blockData.typeSafeIterable()) {
            if (!pattern.matcher(blockData.func_148750_c((Object)block)).matches()) continue;
            if (blockData.getId((Object)block) > 255) {
                D3Core.getLogger().warn("[EndermanGriefing] Blocks with ID > 255 won't work! Not accepting {}", new Object[]{blockData.func_148750_c((Object)block)});
                continue;
            }
            blocks.add(block);
        }
        return blocks;
    }

    public static void undo() {
        for (String entry : reverseMap.keySet()) {
            EntityEnderman.setCarriable((Block)((Block)GameData.getBlockRegistry().func_82594_a(entry)), (boolean)reverseMap.get(entry));
        }
    }

    static {
        reverseMap = new HashMap();
    }
}

