/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech;

import dalapo.factech.CommonProxy;
import dalapo.factech.gui.handbook.GuiHandbook;
import dalapo.factech.gui.handbook.HandbookEntry;
import dalapo.factech.helper.Logger;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.init.FacEntityRegistry;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.init.ModFluidRegistry;
import dalapo.factech.init.TileRegistry;
import dalapo.factech.reference.MachineInfoList;
import dalapo.factech.render.BakedModelLoader;
import dalapo.factech.render.MagnifyingGlassOverlay;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    String language;

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        super.preInit(evt);
        MinecraftForge.EVENT_BUS.register((Object)MagnifyingGlassOverlay.instance);
        OBJLoader.INSTANCE.addDomain("factorytech");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BakedModelLoader());
        FacEntityRegistry.registerEntityRenderers();
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
        this.language = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        try {
            this.initHandbookPages();
        }
        catch (UnsupportedEncodingException e) {
            Logger.fatal("Nope, that's not the right charset!");
            throw new RuntimeException(e);
        }
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        super.postInit(evt);
        this.language = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        BlockRegistry.initInvModels();
    }

    void initHandbookPages() throws UnsupportedEncodingException {
        GuiHandbook.entries.clear();
        Logger.info(String.format("Initializing blueprint collection in language %s", this.language));
        String[] names = new String[]{"basic", "machine", "part", "tool", "automation", "resource", "misc"};
        for (int i = 0; i < names.length; ++i) {
            IResource textRes;
            GuiHandbook.entries.add(new ArrayList());
            try {
                textRes = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("factorytech", "text/" + this.language + "/" + names[i] + ".txt"));
            }
            catch (IOException e) {
                Logger.warn(String.format("Language %s not found in text folder; defaulting to Canadian English", this.language));
                try {
                    textRes = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("factorytech", "text/en_us/" + names[i] + ".txt"));
                }
                catch (IOException ex) {
                    Logger.fatal(String.format("***WARNING: Text file %s.txt not found in text directory; game is likely to crash***", names[i]));
                    return;
                }
            }
            int numEntries = 0;
            Scanner file = new Scanner(new InputStreamReader(textRes.func_110527_b(), "UTF-8"));
            String workingTitle = "";
            String page = "";
            String machineClass = "";
            ArrayList<String> text = new ArrayList<String>();
            ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
            while (file.hasNextLine()) {
                String s = file.nextLine();
                if (s.startsWith("#")) continue;
                if (s.startsWith("$title")) {
                    ++numEntries;
                    workingTitle = s.substring(7);
                    continue;
                }
                if (s.startsWith("$recipe")) {
                    recipes.add(CraftingManager.func_193373_a((ResourceLocation)new ResourceLocation("factorytech", s.substring(8))));
                    continue;
                }
                if (s.startsWith("$machine")) {
                    machineClass = s.substring(9);
                    continue;
                }
                if (!s.startsWith("$")) {
                    page = page + s + '\n';
                    continue;
                }
                if (s.startsWith("$page")) {
                    text.add(page);
                    page = "";
                    continue;
                }
                if (s.startsWith("$brief")) {
                    int firstFlag = s.indexOf(37);
                    int secondFlag = s.indexOf(37, firstFlag + 1);
                    String machineName = s.substring(firstFlag + 1, secondFlag);
                    MachineInfoList.dictionary.put(machineName, s.substring(secondFlag + 2));
                    continue;
                }
                if (!s.equals("$end")) continue;
                text.add(page);
                GuiHandbook.entries.get(i).add(new HandbookEntry(workingTitle, text, recipes, machineClass));
                page = "";
                machineClass = "";
                text.clear();
                recipes.clear();
            }
            GuiHandbook.setPageCount(i, numEntries == 0 ? numEntries : numEntries - 1);
            file.close();
        }
        GuiHandbook.initBackgrounds();
    }

    @SubscribeEvent
    public void initTextures(TextureStitchEvent.Pre evt) {
        ModFluidRegistry.initTextures(evt);
    }

    @SubscribeEvent
    public void initModels(ModelRegistryEvent evt) {
        BlockRegistry.initModels();
        ItemRegistry.initModels();
        TileRegistry.initTESRs();
    }
}

