/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech;

import dalapo.factech.FactoryTech;
import dalapo.factech.auxiliary.ChunkLoadRegistry;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.gui.FacTechGuiHandler;
import dalapo.factech.helper.Logger;
import dalapo.factech.init.ModFluidRegistry;
import dalapo.factech.init.TabRegistry;
import dalapo.factech.init.TileRegistry;
import dalapo.factech.init.WorldGenRegistry;
import dalapo.factech.packet.PacketHandler;
import dalapo.factech.plugins.crafttweaker.ScheduledAdditions;
import dalapo.factech.plugins.crafttweaker.ScheduledRemovals;
import dalapo.factech.tileentity.specialized.TileEntitySluice;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class CommonProxy {
    public static Configuration config;
    public static Configuration machineConfig;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        File directory = evt.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "factorytech.cfg"));
        machineConfig = new Configuration(new File(directory.getPath(), "factorytech_maintenance.cfg"));
        FacTechConfigManager.readConfig();
        TabRegistry.init();
        ModFluidRegistry.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)FactoryTech.instance, (IGuiHandler)new FacTechGuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        TileRegistry.init();
        WorldGenRegistry.init();
        PacketHandler.registerMessages("factech");
        ChunkLoadRegistry.instance.init();
        TileEntitySluice.genBiomeWhitelist();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Logger.info("Entered postInit");
        FacTechConfigManager.initDeepDrillCustomOres();
        ScheduledRemovals.INSTANCE.removeAll();
        ScheduledAdditions.addAll();
        if (config.hasChanged()) {
            config.save();
        }
    }
}

