/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech;

import dalapo.factech.ClientProxy;
import dalapo.factech.FactoryTech;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.auxiliary.PotionLockdown;
import dalapo.factech.block.BlockBase;
import dalapo.factech.block.IBlockSpecialItem;
import dalapo.factech.entity.EntityHoverScooter;
import dalapo.factech.entity.EntityPressureGunShot;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.init.DictRegistry;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.init.RecipeRegistry;
import dalapo.factech.item.block.ItemBlockSubtypes;
import dalapo.factech.tileentity.TileEntityMachine;
import dalapo.factech.tileentity.specialized.TileEntityDisassembler;
import java.io.UnsupportedEncodingException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class FacTechEventManager {
    public static FacTechEventManager instance = new FacTechEventManager();

    private FacTechEventManager() {
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Logger.info("Entered registerBlocks");
        BlockRegistry.init();
        for (Block block : BlockRegistry.blocks) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register(new EntityEntry(EntityPressureGunShot.class, "PressureGunShot").setRegistryName("PressureGunShot"));
        event.getRegistry().register(new EntityEntry(EntityHoverScooter.class, "hoverscooter").setRegistryName("hoverscooter"));
        int id = 0;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("factorytech", "pressureshot"), EntityPressureGunShot.class, (String)"pressureshot", (int)id++, (Object)FactoryTech.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("factorytech", "hoverscooter"), EntityHoverScooter.class, (String)"hoverscooter", (int)id++, (Object)FactoryTech.instance, (int)64, (int)300, (boolean)true);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemRegistry.init();
        for (BlockBase b : BlockRegistry.blocks) {
            if (b instanceof IBlockSpecialItem) {
                event.getRegistry().register(new ItemBlockSubtypes(b).setRegistryName(b.getRegistryName()));
                continue;
            }
            event.getRegistry().register(new ItemBlock((Block)b).setRegistryName(b.getRegistryName()));
        }
        for (Item i : ItemRegistry.items) {
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)PotionLockdown.INSTANCE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        DictRegistry.registerOreDictEntries();
        RecipeRegistry.init();
    }

    @SubscribeEvent
    public void cancelDisassemblyDrops(LivingDropsEvent evt) {
        if (evt.getSource().field_76373_n.equals("machine") && MachineRecipes.DISASSEMBLER.containsKey(TileEntityDisassembler.getMobName(evt.getEntityLiving().getClass()))) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void blockTeleport(EnderTeleportEvent evt) {
        BlockPos enderPos;
        if (evt.getEntityLiving() instanceof EntityEnderman && (evt.getEntityLiving().field_70170_p.func_175625_s(FacMathHelper.withOffset(enderPos = evt.getEntity().func_180425_c(), EnumFacing.DOWN)) instanceof TileEntityDisassembler || evt.getEntityLiving().func_70660_b((Potion)PotionLockdown.INSTANCE) != null)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void noShootingForYou(LivingEntityUseItemEvent.Start e) {
        if (!(e.getEntityLiving() instanceof EntityPlayer) && e.getEntityLiving().func_70660_b((Potion)PotionLockdown.INSTANCE) != null && e.getItem().func_77973_b() == Items.field_151031_f) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void syncTankFill(FluidEvent e) {
        TileEntity te = e.getWorld().func_175625_s(e.getPos());
        Block b = e.getWorld().func_180495_p(e.getPos()).func_177230_c();
        if (BlockRegistry.blocks.contains(b)) {
            FacBlockHelper.updateBlock(e.getWorld(), e.getPos());
            if (te instanceof TileEntityMachine) {
                ((TileEntityMachine)te).getHasWork();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void updateLanguage(GuiScreenEvent.ActionPerformedEvent e) {
        if (e.getGui() instanceof GuiLanguage) {
            ((ClientProxy)FactoryTech.proxy).language = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            try {
                ((ClientProxy)FactoryTech.proxy).initHandbookPages();
            }
            catch (UnsupportedEncodingException ex) {
                Logger.fatal("Nope, that's not the right charset!");
                throw new RuntimeException();
            }
        }
    }
}

