/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.auxiliary;

import com.google.common.collect.ImmutableSet;
import dalapo.factech.FactoryTech;
import dalapo.factech.auxiliary.ChunkWithDimension;
import dalapo.factech.auxiliary.IChunkLoader;
import dalapo.factech.auxiliary.PosWithDimension;
import dalapo.factech.helper.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkLoadRegistry
implements ForgeChunkManager.LoadingCallback {
    public static final ChunkLoadRegistry instance = new ChunkLoadRegistry();
    public static final Map<PosWithDimension, ForgeChunkManager.Ticket> ticketMap = new HashMap<PosWithDimension, ForgeChunkManager.Ticket>();

    private ChunkLoadRegistry() {
    }

    public void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FactoryTech.instance, (ForgeChunkManager.LoadingCallback)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload evt) {
        Iterator<PosWithDimension> iterator = ticketMap.keySet().iterator();
        while (iterator.hasNext()) {
            PosWithDimension pos = iterator.next();
            if (pos.getDimension() != evt.getWorld().field_73011_w.getDimension()) continue;
            iterator.remove();
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        Logger.info("Entered ticketsLoaded");
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int z;
            int y;
            NBTTagCompound nbt = ticket.getModData();
            int x = nbt.func_74762_e("tileX");
            TileEntity te = world.func_175625_s(new BlockPos(x, y = nbt.func_74762_e("tileY"), z = nbt.func_74762_e("tileZ")));
            if (te instanceof IChunkLoader) {
                IChunkLoader clte = (IChunkLoader)te;
                PosWithDimension pos = new PosWithDimension(te);
                this.forceChunks(clte.getChunksToLoad(), ticket);
                ticketMap.put(pos, ticket);
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public ForgeChunkManager.Ticket loadChunks(PosWithDimension pos, List<ChunkWithDimension> chunks) {
        ForgeChunkManager.Ticket ticket = ticketMap.get((Object)pos);
        if (ticket == null) {
            ticket = ForgeChunkManager.requestTicket((Object)FactoryTech.instance, (World)pos.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            NBTTagCompound nbt = ticket.getModData();
            nbt.func_74768_a("tileX", pos.func_177958_n());
            nbt.func_74768_a("tileY", pos.func_177956_o());
            nbt.func_74768_a("tileZ", pos.func_177952_p());
            ticketMap.put(pos, ticket);
        }
        this.forceChunks(chunks, ticket);
        return ticket;
    }

    public void unloadChunks(PosWithDimension pos) {
        ForgeChunkManager.Ticket ticket = ticketMap.remove((Object)pos);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }

    public void forceChunks(List<ChunkWithDimension> chunks, ForgeChunkManager.Ticket ticket) {
        ImmutableSet toLoad = ticket.getChunkList();
        for (ChunkPos chunkPos : toLoad) {
            if (chunks.contains(chunkPos)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        }
        for (ChunkPos chunkPos : chunks) {
            if (toLoad.contains((Object)chunkPos)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        }
    }
}

