/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.auxiliary;

import dalapo.factech.tileentity.TileEntityFluidMachine;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerWrapper
implements IFluidHandler {
    FluidTank[] tanks;
    int outputCutoff;
    TileEntityFluidMachine parent;

    public FluidHandlerWrapper(FluidTank[] tanks, int outCut, TileEntityFluidMachine parent) {
        int i;
        this.tanks = tanks;
        this.outputCutoff = outCut < tanks.length && outCut >= 0 ? outCut : tanks.length;
        for (i = 0; i < this.outputCutoff; ++i) {
            tanks[i].setCanDrain(false);
        }
        for (i = this.outputCutoff; i < tanks.length; ++i) {
            tanks[i].setCanFill(false);
        }
        this.parent = parent;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] properties = new IFluidTankProperties[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            properties[i] = new FluidTankPropertiesWrapper(this.tanks[i]);
        }
        return properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        FluidTank tank;
        int i;
        int target = -1;
        boolean amt = false;
        for (i = 0; i < this.tanks.length; ++i) {
            tank = this.tanks[i];
            if (tank.getFluid() != null && !tank.getFluid().isFluidEqual(resource) || !tank.canFill()) continue;
            this.parent.onTankUpdate();
            return tank.fill(resource, doFill);
        }
        for (i = 0; i < this.tanks.length; ++i) {
            tank = this.tanks[i];
            if (tank.getFluid() != null || !tank.canFill()) continue;
            this.parent.onTankUpdate();
            return tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int start = this.outputCutoff < this.tanks.length ? this.outputCutoff : 0;
        FluidStack fs = null;
        for (int i = start; i < this.tanks.length; ++i) {
            if (this.tanks[i].getFluid() == null || !this.tanks[i].getFluid().isFluidEqual(resource) || !this.tanks[i].canDrain()) continue;
            fs = this.tanks[i].drain(resource, doDrain);
            break;
        }
        this.parent.onTankUpdate();
        return fs;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int start = this.outputCutoff < this.tanks.length ? this.outputCutoff : 0;
        FluidStack fs = null;
        for (int i = start; i < this.tanks.length; ++i) {
            if (!this.tanks[i].canDrain() || this.tanks[i].getFluidAmount() <= 0) continue;
            fs = this.tanks[i].drain(maxDrain, doDrain);
            break;
        }
        this.parent.onTankUpdate();
        return fs;
    }
}

