/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.auxiliary;

import dalapo.factech.init.ItemRegistry;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.TileEntityOldMachine;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MachinePart {
    private boolean isCrappy;
    public PartList id;
    private ItemStack depleted;
    private double quality = 1.0;
    private double speed = 1.0;
    private TileEntityOldMachine parent;
    private int numOperations = 0;
    private int minOperations;
    private float curBreakChance;
    private float baseBreakChance;
    public float salvageChance;
    private float increase;

    public MachinePart(PartList id, ItemStack salvage, float base, float inc, float chance, int minOperations) {
        if (base < 0.0f || inc < 0.0f) {
            throw new IllegalArgumentException("Base and increase degrade chances must both be positive!");
        }
        this.id = id;
        this.minOperations = minOperations;
        this.numOperations = 0;
        this.baseBreakChance = base;
        this.curBreakChance = base;
        this.increase = inc;
        this.depleted = salvage.func_77946_l();
        this.salvageChance = chance;
    }

    public int getRemainingOperations() {
        return this.getActualMin() - this.numOperations;
    }

    public int getMinOperations() {
        return this.minOperations;
    }

    public float getBaseChance() {
        return this.baseBreakChance;
    }

    public float getIncrease() {
        return this.increase;
    }

    public float getSalvageChance() {
        return this.salvageChance;
    }

    public double getQuality() {
        return this.quality;
    }

    public double getSpeed() {
        return this.speed;
    }

    public MachinePart(TileEntityOldMachine parent, ItemStack is, PartList part, float base, float inc, float chance, int numOperations) {
        this(part, is.func_77946_l(), base, inc, chance, numOperations);
        if (!part.hasCustomSalvage()) {
            this.depleted = new ItemStack((Item)ItemRegistry.salvagePart, 1, part.getSalvageMeta());
        }
        this.parent = parent;
    }

    public MachinePart(TileEntityOldMachine parent, MachinePart toCopy) {
        this(parent, new ItemStack(toCopy.id.getSalvage(), toCopy.id.getSalvageAmount(), toCopy.id.getSalvageMeta()), toCopy.id, toCopy.baseBreakChance, toCopy.increase, toCopy.salvageChance, toCopy.minOperations);
    }

    public MachinePart(PartList part, float base, float inc, float chance, int numOperations) {
        this(part, new ItemStack(part.getSalvage(), 1, part.getSalvageMeta()), base, inc, chance, numOperations);
        if (!part.hasCustomSalvage()) {
            this.depleted = new ItemStack((Item)ItemRegistry.salvagePart, 1, part.getSalvageMeta());
        }
    }

    public MachinePart(PartList part, float base, float inc) {
        this(part, ItemStack.field_190927_a, base, inc, 0.0f, 0);
    }

    public MachinePart(PartList part, float base, float inc, int min) {
        this(part, ItemStack.field_190927_a, base, inc, 0.0f, min);
    }

    public PartList getPartID() {
        return this.id;
    }

    public void reset(int variant) {
        this.numOperations = 0;
        this.quality = this.id.getLifetimeModifier(variant);
        this.speed = this.id.getSpeedModifier(variant);
        this.curBreakChance = this.baseBreakChance;
        this.isCrappy = this.id.hasBadVariant() && this.quality < 1.0;
    }

    public boolean isBad() {
        return this.isCrappy;
    }

    public ItemStack getSalvage() {
        return this.depleted.func_77946_l();
    }

    public int getActualMin() {
        int actualMin = this.minOperations;
        switch (this.parent.getInstalledUpgrade()) {
            case 1: {
                actualMin = (int)((double)actualMin * 0.67);
                break;
            }
            case 2: {
                actualMin = (int)((double)actualMin * 1.5);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                actualMin *= 2;
                break;
            }
        }
        return (int)((double)actualMin * this.quality);
    }

    public void increaseChance() {
        ++this.numOperations;
        if (this.numOperations >= this.getActualMin()) {
            this.curBreakChance *= this.increase;
        }
    }

    public boolean shouldBreak() {
        if (this.numOperations < this.getActualMin()) {
            return false;
        }
        switch (this.parent.getInstalledUpgrade()) {
            case 1: {
                return Math.random() / 1.5 < (double)this.curBreakChance;
            }
            case 2: {
                return Math.random() * 1.5 < (double)this.curBreakChance;
            }
            case 4: {
                return true;
            }
        }
        return Math.random() < (double)this.curBreakChance;
    }

    public String serializeNBT() {
        return String.format("%s:%s:%s:%s:%s", this.numOperations, Float.valueOf(this.curBreakChance), Float.valueOf(this.increase), this.quality, this.isCrappy);
    }

    public void deserializeNBT(String str) {
        String[] arr = str.split(":");
        this.numOperations = Integer.parseInt(arr[0]);
        this.curBreakChance = Float.parseFloat(arr[1]);
        this.increase = Float.parseFloat(arr[2]);
        this.quality = Double.parseDouble(arr[3]);
        this.isCrappy = Boolean.parseBoolean(arr[4]);
    }
}

