/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.auxiliary;

import dalapo.factech.auxiliary.IMachineRecipe;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.helper.Pair;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.init.ModFluidRegistry;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.specialized.TileEntityAgitator;
import dalapo.factech.tileentity.specialized.TileEntityCompressionChamber;
import dalapo.factech.tileentity.specialized.TileEntitySluice;
import dalapo.factech.tileentity.specialized.TileEntityTemperer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class MachineRecipes {
    public static List<MachineRecipe<ItemStack, ItemStack>> SAW = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> GRINDSTONE = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack[]>> CENTRIFUGE = new ArrayList<MachineRecipe<ItemStack, ItemStack[]>>();
    public static List<MachineRecipe<ItemStack, ItemStack[]>> MAGNET_CENTRIFUGE = new ArrayList<MachineRecipe<ItemStack, ItemStack[]>>();
    public static List<MachineRecipe<FluidStack, ItemStack[]>> MAGNET_CENTRIFUGE_NEW = new ArrayList<MachineRecipe<FluidStack, ItemStack[]>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> METALCUTTER = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> MAGNETIZER = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, FluidStack>> CRUCIBLE = new ArrayList<MachineRecipe<ItemStack, FluidStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> HTFURNACE = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> OREDRILL = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> CIRCUIT_SCRIBE = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<MachineRecipe<FluidStack, ItemStack>> REFRIGERATOR = new ArrayList<MachineRecipe<FluidStack, ItemStack>>();
    public static List<MachineRecipe<ItemStack, ItemStack>> RECLAIMER = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static Map<String, List<ItemStack>> DISASSEMBLER = new HashMap<String, List<ItemStack>>();
    public static Map<ItemStack, Block> PLANTER = new HashMap<ItemStack, Block>();
    public static List<MachineRecipe<ItemStack, ItemStack>> ELECTROPLATER = new ArrayList<MachineRecipe<ItemStack, ItemStack>>();
    public static List<TileEntityCompressionChamber.CompressorRecipe> COMPRESSOR = new ArrayList<TileEntityCompressionChamber.CompressorRecipe>();
    public static List<TileEntityAgitator.AgitatorRecipe> AGITATOR = new ArrayList<TileEntityAgitator.AgitatorRecipe>();
    public static List<TileEntityTemperer.TempererRecipe> TEMPERER = new ArrayList<TileEntityTemperer.TempererRecipe>();
    public static List<Pair<ItemStack, Double>> DEEP_DRILL = new ArrayList<Pair<ItemStack, Double>>();

    public static void initRecipes() {
        int i;
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ItemRegistry.minedOre, 1, 4), (ItemStack)new ItemStack(Items.field_151042_j), (float)6.0f);
        for (i = 0; i < 4; ++i) {
            SAW.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150364_r, 1, i), new ItemStack(Blocks.field_150344_f, 6, i), true));
        }
        for (i = 0; i < 2; ++i) {
            SAW.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150363_s, 1, i), new ItemStack(Blocks.field_150344_f, 6, i + 4), true));
        }
        SAW.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE), new ItemStack(Items.field_151055_y, 3), true));
        SAW.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE), new ItemStack((Item)ItemRegistry.circuitIntermediate, 6, 8), false));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150348_b), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BLADE.getFloor()), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 7), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BLADE.getFloor() + 1), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor()), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.SAW.getFloor()), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 1), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.SAW.getFloor() + 1), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 2), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.SAW.getFloor() + 2), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.intermediate, 1, 5), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.DRILL.getFloor() + 2), false));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.intermediate, 1, 6), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.DRILL.getFloor() + 1), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150359_w), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.LENS.getFloor()), true));
        GRINDSTONE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 3), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.SAW.getFloor() + 3), false));
        CRUCIBLE.add(new MachineRecipe<ItemStack, FluidStack>(new ItemStack(Blocks.field_150432_aD, 1), new FluidStack(FluidRegistry.WATER, 1000), true));
        CRUCIBLE.add(new MachineRecipe<ItemStack, FluidStack>(new ItemStack(Blocks.field_150347_e, 1), new FluidStack(FluidRegistry.LAVA, 50), false));
        CRUCIBLE.add(new MachineRecipe<ItemStack, FluidStack>(new ItemStack(Blocks.field_150424_aL, 1), new FluidStack(FluidRegistry.LAVA, 500), false));
        CRUCIBLE.add(new MachineRecipe<ItemStack, FluidStack>(new ItemStack(Items.field_151114_aO, 1), new FluidStack((Fluid)ModFluidRegistry.glowstone, 100), false));
        METALCUTTER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 7), new ItemStack((Item)ItemRegistry.intermediate, 1, 6)));
        METALCUTTER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 6), new ItemStack((Item)ItemRegistry.machinePart, 2, PartList.WIRE.getFloor()), true));
        METALCUTTER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 5), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 1), true));
        METALCUTTER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Items.field_151042_j), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 2), true));
        MAGNETIZER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Items.field_151042_j), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.MAGNET.getFloor()), false));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 0), new ItemStack(Items.field_151042_j, 2)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 1), new ItemStack(Items.field_151043_k, 2)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 2), new ItemStack((Item)ItemRegistry.ingot, 2, 0)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 3), new ItemStack((Item)ItemRegistry.ingot, 2, 1)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 6), new ItemStack(Items.field_151042_j)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 7), new ItemStack(Items.field_151043_k)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151114_aO)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Items.field_151128_bU)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.minedOre, 1, 2), new ItemStack(Items.field_151043_k, 1)));
        ELECTROPLATER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.minedOre, 1, 2), new ItemStack((Item)ItemRegistry.ingot, 2, 0)));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150351_n), true));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), true));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150366_p), new ItemStack((Item)ItemRegistry.oreProduct, 2, 0), true));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150352_o), new ItemStack((Item)ItemRegistry.oreProduct, 2, 1), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax, 10), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 12, 4), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i, 2), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack((Item)ItemRegistry.oreProduct, 1, 12), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150368_y), new ItemStack((Item)ItemRegistry.oreProduct, 9, 12), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack(Blocks.field_150343_Z), new ItemStack((Item)ItemRegistry.intermediate, 1, 0), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.minedOre, 1, 0), new ItemStack((Item)ItemRegistry.minedOre, 2, 2), false));
        OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.minedOre, 1, 1), new ItemStack((Item)ItemRegistry.minedOre, 2, 3), false));
        CIRCUIT_SCRIBE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8), ItemStack.field_190927_a, false));
        MAGNET_CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack(Blocks.field_150351_n, 4), new ItemStack[]{new ItemStack(Items.field_151145_ak, 2), new ItemStack(Items.field_191525_da, 2), new ItemStack((Item)ItemRegistry.oreProduct, 2, 5)}, false));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack(Blocks.field_150351_n, 1), new ItemStack[]{new ItemStack(Items.field_151145_ak, 1)}, true));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 0), new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 1, 6), new ItemStack((Item)ItemRegistry.oreProduct, 1, 5)}, false));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 1), new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 1, 7), new ItemStack((Item)ItemRegistry.oreProduct, 1, 4)}, false));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 2), new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 1, 8), new ItemStack(Items.field_151074_bl)}, false));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 3), new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 1, 9), new ItemStack(Items.field_191525_da)}, true));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.oreProduct, 4, 10), new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 3, 8), new ItemStack((Item)ItemRegistry.oreProduct, 1, 9)}, true));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.minedOre, 1, 4), new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 1, 6), new ItemStack((Item)ItemRegistry.oreProduct, 1, 9)}, true));
        CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Block)Blocks.field_150354_m, 4, 1), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 4, 0), new ItemStack(Items.field_151137_ax, 1)}, true));
        MAGNET_CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.minedOre, 1, 2), new ItemStack[]{new ItemStack(Blocks.field_150351_n), new ItemStack((Item)ItemRegistry.minedOre, 1, 4)}, false));
        MAGNET_CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(new ItemStack((Item)ItemRegistry.minedOre, 1, 3), new ItemStack[]{new ItemStack(Items.field_151137_ax, 6), new ItemStack(Items.field_151100_aR, 2, 4)}, false));
        REFRIGERATOR.add(new MachineRecipe<FluidStack, ItemStack>(new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150432_aD), true));
        REFRIGERATOR.add(new MachineRecipe<FluidStack, ItemStack>(new FluidStack(FluidRegistry.LAVA, 1000), new ItemStack(Blocks.field_150343_Z), true));
        REFRIGERATOR.add(new MachineRecipe<FluidStack, ItemStack>(new FluidStack((Fluid)ModFluidRegistry.propane, 1000), new ItemStack(Items.field_151044_h), false));
        REFRIGERATOR.add(new MachineRecipe<FluidStack, ItemStack>(new FluidStack((Fluid)ModFluidRegistry.glowstone, 400), new ItemStack(Blocks.field_150426_aN), false));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(ItemStack.field_190927_a, ItemStack.field_190927_a, new FluidStack((Fluid)ModFluidRegistry.h2so4, 1000), new FluidStack(FluidRegistry.WATER, 1000), new FluidStack((Fluid)ModFluidRegistry.sulphur, 1000)));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(ItemStack.field_190927_a, new ItemStack(Blocks.field_150348_b), null, new FluidStack(FluidRegistry.WATER, 1000), new FluidStack(FluidRegistry.LAVA, 1)));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Items.field_151119_aD), null, new FluidStack(FluidRegistry.WATER, 1000), null));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151065_br), null, new FluidStack((Fluid)ModFluidRegistry.sulphur, 250), null));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack((Item)ItemRegistry.intermediate, 1, 3), ItemStack.field_190927_a, new FluidStack((Fluid)ModFluidRegistry.energite, 200), new FluidStack((Fluid)ModFluidRegistry.glowstone, 100), new FluidStack((Fluid)ModFluidRegistry.h2so4, 100)));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack((Block)Blocks.field_150362_t, 1, Short.MAX_VALUE), new ItemStack(Items.field_151123_aH), null, new FluidStack(FluidRegistry.WATER, 250), null));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack((Block)Blocks.field_150361_u, 1, Short.MAX_VALUE), new ItemStack(Items.field_151123_aH), null, new FluidStack(FluidRegistry.WATER, 250), null));
        AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151116_aA), null, new FluidStack((Fluid)ModFluidRegistry.h2so4, 200), null));
        for (i = 0; i < 16; ++i) {
            AGITATOR.add(new TileEntityAgitator.AgitatorRecipe(new ItemStack(Blocks.field_192444_dS, 1, i), new ItemStack(Blocks.field_192443_dR, 1, i), null, new FluidStack(FluidRegistry.WATER, 100), null));
        }
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), null, new ItemStack((Item)ItemRegistry.tank, 1, 1)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), new FluidStack(FluidRegistry.WATER, 1000), new ItemStack((Item)ItemRegistry.tank, 1, 2)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), new FluidStack((Fluid)ModFluidRegistry.propane, 1000), new ItemStack((Item)ItemRegistry.tank, 1, 3)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), new FluidStack((Fluid)ModFluidRegistry.h2so4, 1000), new ItemStack((Item)ItemRegistry.tank, 1, 4)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), new FluidStack((Fluid)ModFluidRegistry.sulphur, 1000), new ItemStack((Item)ItemRegistry.tank, 1, 5)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), new FluidStack((Fluid)ModFluidRegistry.glowstone, 1000), new ItemStack((Item)ItemRegistry.tank, 1, 6)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.tank, 1, 0), new FluidStack((Fluid)ModFluidRegistry.energite, 1000), new ItemStack((Item)ItemRegistry.tank, 1, 7)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.intermediate, 1, 1), new FluidStack((Fluid)ModFluidRegistry.energite, 250), new ItemStack((Item)ItemRegistry.coreUnfinished, 1, 99)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.intermediate, 1, 2), new FluidStack((Fluid)ModFluidRegistry.h2so4, 250), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BATTERY.getFloor())));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.intermediate, 1, 2), new FluidStack((Fluid)ModFluidRegistry.energite, 250), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BATTERY.getFloor() + 1)));
        COMPRESSOR.add(new TileEntityCompressionChamber.CompressorRecipe(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.MOTOR.getFloor()), new FluidStack((Fluid)ModFluidRegistry.energite, 200), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.MOTOR.getFloor() + 2)));
        TEMPERER.add(new TileEntityTemperer.TempererRecipe(new ItemStack(Items.field_151042_j), new ItemStack((Item)ItemRegistry.ingot, 1, 4), 71));
        TEMPERER.add(new TileEntityTemperer.TempererRecipe(new ItemStack(Blocks.field_150339_S), new ItemStack((Item)ItemRegistry.ingot, 2, 4), 335));
        TEMPERER.add(new TileEntityTemperer.TempererRecipe(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.SAW.getFloor() + 2), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.SAW.getFloor() + 4), 73));
        TEMPERER.add(new TileEntityTemperer.TempererRecipe(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 2), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 4), 66));
        TEMPERER.add(new TileEntityTemperer.TempererRecipe(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.DRILL.getFloor() + 2), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.DRILL.getFloor() + 3), 89));
        TEMPERER.add(new TileEntityTemperer.TempererRecipe(new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BLADE.getFloor() + 2), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BLADE.getFloor() + 3), 54));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack(Blocks.field_150365_q), 2.0));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack(Blocks.field_150366_p), 1.0));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack(Blocks.field_150352_o), 0.25));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack(Blocks.field_150450_ax), 0.8));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack(Blocks.field_150369_x), 0.3));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack(Blocks.field_150482_ag), 0.1));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack((Block)BlockRegistry.ore, 1, 0), 1.0));
        DEEP_DRILL.add(new Pair<ItemStack, Double>(new ItemStack((Block)BlockRegistry.ore, 1, 1), 0.8));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 4), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_0.getFloor()), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 5), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_1.getFloor()), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 6), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_2.getFloor()), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 7), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_3.getFloor()), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 9), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_0.getFloor() + 1), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 10), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_1.getFloor() + 1), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 11), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_2.getFloor() + 1), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 12), new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.CIRCUIT_3.getFloor() + 1), false));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 5), new ItemStack(Items.field_151042_j)));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 6), new ItemStack((Item)ItemRegistry.ingot, 1, 0)));
        HTFURNACE.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.ingot, 1, 7), new ItemStack((Item)ItemRegistry.ingot, 1, 1)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 1), new ItemStack((Item)ItemRegistry.oreProduct, 7, 15)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 2), new ItemStack(Items.field_191525_da, 7)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 3), new ItemStack((Item)ItemRegistry.oreProduct, 7, 18)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 4), new ItemStack(Items.field_191525_da, 7)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 11), new ItemStack((Item)ItemRegistry.oreProduct, 8, 15)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 12), new ItemStack(Items.field_191525_da, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 13), new ItemStack((Item)ItemRegistry.oreProduct, 8, 18)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 14), new ItemStack(Items.field_191525_da, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 20), new ItemStack((Item)ItemRegistry.oreProduct, 4, 16)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 21), new ItemStack((Item)ItemRegistry.oreProduct, 4, 4)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 22), new ItemStack(Items.field_151074_bl, 4)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 31), new ItemStack((Item)ItemRegistry.oreProduct, 8, 17)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 32), new ItemStack((Item)ItemRegistry.oreProduct, 8, 5)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 33), new ItemStack((Item)ItemRegistry.oreProduct, 8, 5)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 34), new ItemStack((Item)ItemRegistry.oreProduct, 8, 5)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 50), new ItemStack((Item)ItemRegistry.oreProduct, 8, 15)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 51), new ItemStack(Items.field_191525_da, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 71), new ItemStack((Item)ItemRegistry.oreProduct, 8, 17)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 72), new ItemStack((Item)ItemRegistry.oreProduct, 8, 5)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 73), new ItemStack(Items.field_191525_da, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 80), new ItemStack((Item)ItemRegistry.ingot, 3, 2)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 81), new ItemStack((Item)ItemRegistry.ingot, 3, 2)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 90), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 91), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 100), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 101), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 110), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 111), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 120), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        RECLAIMER.add(new MachineRecipe<ItemStack, ItemStack>(new ItemStack((Item)ItemRegistry.salvagePart, 1, 121), new ItemStack((Item)ItemRegistry.circuitIntermediate, 1, 8)));
        TileEntitySluice.outputs.add(new Pair<ItemStack, Double>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 15), 0.2));
        TileEntitySluice.outputs.add(new Pair<ItemStack, Double>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 16), 0.15));
        TileEntitySluice.outputs.add(new Pair<ItemStack, Double>(new ItemStack((Item)ItemRegistry.oreProduct, 1, 17), 0.15));
        TileEntitySluice.outputs.add(new Pair<ItemStack, Double>(new ItemStack(Items.field_151115_aP), 0.03125));
        MachineRecipes.addDisassemblerRecipes();
    }

    private static void addDisassemblerRecipes() {
        ArrayList<ItemStack> zombie = new ArrayList<ItemStack>();
        zombie.add(new ItemStack(Items.field_151078_bh, 4));
        zombie.add(new ItemStack(Items.field_151103_aS, 1));
        zombie.add(new ItemStack(Item.func_150899_d((int)397), 1, 2));
        zombie.add(new ItemStack((Item)ItemRegistry.intermediate, 1, 3));
        DISASSEMBLER.put("EntityZombie", zombie);
        ArrayList<ItemStack> skeleton = new ArrayList<ItemStack>();
        skeleton.add(new ItemStack(Items.field_151103_aS, 4));
        skeleton.add(new ItemStack(Items.field_151032_g, 4));
        skeleton.add(new ItemStack(Item.func_150899_d((int)397), 1, 0));
        skeleton.add(new ItemStack((Item)ItemRegistry.intermediate, 1, 3));
        DISASSEMBLER.put("EntitySkeleton", skeleton);
        ArrayList<ItemStack> spider = new ArrayList<ItemStack>();
        spider.add(new ItemStack(Items.field_151007_F, 4));
        spider.add(new ItemStack(Items.field_151070_bp, 3));
        spider.add(new ItemStack(Items.field_151116_aA, 1));
        spider.add(new ItemStack((Item)ItemRegistry.intermediate, 1, 3));
        DISASSEMBLER.put("EntitySpider", spider);
        DISASSEMBLER.put("EntityCaveSpider", spider);
        ArrayList<ItemStack> creeper = new ArrayList<ItemStack>();
        creeper.add(new ItemStack(Items.field_151016_H, 4));
        creeper.add(new ItemStack(Item.func_150899_d((int)397), 1, 4));
        creeper.add(new ItemStack((Item)ItemRegistry.intermediate, 1, 3));
        DISASSEMBLER.put("EntityCreeper", creeper);
        ArrayList<ItemStack> pigzombie = new ArrayList<ItemStack>();
        pigzombie.add(new ItemStack(Items.field_151078_bh, 3));
        pigzombie.add(new ItemStack(Items.field_151010_B, 1));
        pigzombie.add(new ItemStack(Items.field_151074_bl, 2));
        pigzombie.add(new ItemStack(Items.field_151157_am, 1));
        pigzombie.add(new ItemStack((Item)ItemRegistry.intermediate, 1, 3));
        DISASSEMBLER.put("EntityPigZombie", pigzombie);
        ArrayList<ItemStack> enderman = new ArrayList<ItemStack>();
        enderman.add(new ItemStack(Items.field_151079_bi, 2));
        enderman.add(new ItemStack(Blocks.field_150343_Z, 1));
        enderman.add(new ItemStack((Item)ItemRegistry.intermediate, 1, 3));
        DISASSEMBLER.put("EntityEnderman", enderman);
        ArrayList<ItemStack> blaze = new ArrayList<ItemStack>();
        blaze.add(new ItemStack(Items.field_151072_bj, 3));
        blaze.add(new ItemStack(Items.field_151059_bz, 2));
        blaze.add(new ItemStack(Items.field_151016_H, 1));
        DISASSEMBLER.put("EntityBlaze", blaze);
    }

    private static boolean hasOre(String str) {
        return OreDictionary.doesOreNameExist((String)str);
    }

    private static void addOreDictRecipe(Map<ItemStack, ItemStack> recipeList, String input, ItemStack output) {
        for (ItemStack in : OreDictionary.getOres((String)input)) {
            recipeList.put(in, output);
        }
    }

    private static void addOreDictRecipe(List<MachineRecipe<ItemStack, ItemStack>> recipeList, String input, ItemStack output, boolean worksWithBad) {
        for (ItemStack in : OreDictionary.getOres((String)input)) {
            recipeList.add(new MachineRecipe<ItemStack, ItemStack>(in, output, worksWithBad));
        }
    }

    private static void addOreDictRecipe(List<Pair<ItemStack, ItemStack>> recipeList, String input, ItemStack output) {
        for (ItemStack in : OreDictionary.getOres((String)input)) {
            recipeList.add(new Pair<ItemStack, ItemStack>(in, output));
        }
    }

    private static void addDrillRecipe(String type) {
        ItemStack result;
        type = FacMiscHelper.capitalizeFirstLetter(type);
        if (MachineRecipes.hasOre("ore" + type) && MachineRecipes.hasOre("dust" + type)) {
            for (ItemStack is : OreDictionary.getOres((String)("ore" + type))) {
                if (!(type.equals("Copper") || type.equals("Nickel") || is.func_77973_b().getRegistryName().func_110624_b().equals("minecraft") || OreDictionary.getOres((String)("dust" + type)).isEmpty())) {
                    result = ((ItemStack)OreDictionary.getOres((String)("dust" + type)).get(0)).func_77946_l();
                    result.func_190920_e(2);
                    Logger.info(String.format("Adding Grinder recipe %s -> %s", is, result));
                    OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(is.func_77946_l(), result, false));
                    continue;
                }
                if (!type.equals("Copper") && !type.equals("Nickel")) continue;
                result = new ItemStack((Item)ItemRegistry.oreProduct, 2, type.equals("Copper") ? 2 : 3);
                Logger.info(String.format("Adding Grinder recipe %s -> %s", is, result));
                OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(is.func_77946_l(), result, type.equals("Copper")));
            }
        }
        if (MachineRecipes.hasOre("ingot" + type) && MachineRecipes.hasOre("dust" + type)) {
            for (ItemStack is : OreDictionary.getOres((String)("ingot" + type))) {
                if (OreDictionary.getOres((String)("dust" + type)).isEmpty()) continue;
                result = ((ItemStack)OreDictionary.getOres((String)("dust" + type)).get(0)).func_77946_l();
                result.func_190920_e(1);
                Logger.info(String.format("Adding Grinder recipe %s -> %s", is, result));
                OREDRILL.add(new MachineRecipe<ItemStack, ItemStack>(is.func_77946_l(), result, false));
            }
        }
    }

    public static void addOreDictRecipes() {
        for (String str : OreDictionary.getOreNames()) {
            if (!str.startsWith("ore")) continue;
            MachineRecipes.addDrillRecipe(str.substring(3));
        }
        MachineRecipes.addOreDictRecipe(GRINDSTONE, "ingotNickel", new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.BLADE.getFloor() + 2), true);
        MachineRecipes.addOreDictRecipe(ELECTROPLATER, "dustCopper", new ItemStack((Item)ItemRegistry.ingot, 1, 0), false);
        MachineRecipes.addOreDictRecipe(ELECTROPLATER, "dustNickel", new ItemStack((Item)ItemRegistry.ingot, 1, 1), false);
        MachineRecipes.addOreDictRecipe(METALCUTTER, "ingotCopper", new ItemStack((Item)ItemRegistry.machinePart, 2, PartList.WIRE.getFloor() + 1), true);
        MachineRecipes.addOreDictRecipe(METALCUTTER, "ingotGold", new ItemStack((Item)ItemRegistry.machinePart, 2, PartList.WIRE.getFloor() + 2), false);
        MachineRecipes.addOreDictRecipe(METALCUTTER, "ingotNickel", new ItemStack((Item)ItemRegistry.intermediate, 1, 5), true);
        MachineRecipes.addOreDictRecipe(METALCUTTER, "ingotInvar", new ItemStack((Item)ItemRegistry.machinePart, 1, PartList.GEAR.getFloor() + 3), false);
        for (ItemStack is : OreDictionary.getOres((String)"dustInvar")) {
            ItemStack copy = is.func_77946_l();
            copy.func_190920_e(3);
            CENTRIFUGE.add(new MachineRecipe<ItemStack, ItemStack[]>(copy, new ItemStack[]{new ItemStack((Item)ItemRegistry.oreProduct, 2, 6), new ItemStack((Item)ItemRegistry.oreProduct, 1, 9)}, true));
        }
    }

    public static void importFurnaceRecipes() {
        for (Map.Entry recipe : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            HTFURNACE.add(new MachineRecipe(recipe.getKey(), recipe.getValue(), true));
        }
    }

    public static class MachineRecipe<K, V>
    implements IMachineRecipe<V> {
        private final K input;
        private final V output;
        private final boolean possibleWithBadParts;

        public MachineRecipe(K input, V output, boolean bad) {
            this.input = input;
            this.output = output;
            this.possibleWithBadParts = bad;
        }

        public MachineRecipe(K input, V output) {
            this(input, output, true);
        }

        public K input() {
            return this.input;
        }

        public V output() {
            return this.output;
        }

        @Override
        public V getOutputStack() {
            return this.output();
        }

        public boolean worksWithBad() {
            return this.possibleWithBadParts;
        }

        public String toString() {
            return String.format("%s -> %s", this.input, this.output);
        }
    }
}

