/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.auxiliary;

import dalapo.factech.FactoryTech;
import net.minecraft.nbt.NBTTagString;

public class NewMachinePart {
    private final double increase;
    private final boolean isBad;
    private final float salvageChance;
    private final double speedMultiplier;
    private final int maxLife;
    private double breakChance;
    private int lifetime;

    public NewMachinePart(int startingLife, float breakChance, float increase, float speed, float salvage, boolean isBad) {
        this.isBad = isBad;
        this.lifetime = startingLife;
        this.maxLife = startingLife;
        this.breakChance = breakChance;
        this.increase = increase;
        this.salvageChance = salvage;
        this.speedMultiplier = speed;
    }

    public NewMachinePart(String s) {
        String[] strings = s.split(":");
        this.lifetime = Integer.parseInt(strings[0]);
        this.maxLife = Integer.parseInt(strings[1]);
        this.breakChance = Double.parseDouble(strings[2]);
        this.increase = Double.parseDouble(strings[3]);
        this.speedMultiplier = Double.parseDouble(strings[4]);
        this.salvageChance = Float.parseFloat(strings[5]);
        this.isBad = Boolean.parseBoolean(strings[6]);
    }

    public NewMachinePart(NBTTagString str) {
        this(str.func_150285_a_());
    }

    public NBTTagString serializeNBT() {
        String str = String.format("%s:%s:%s:%s:%s:%s:%s", this.lifetime, this.maxLife, this.breakChance, this.increase, this.speedMultiplier, Float.valueOf(this.salvageChance), this.isBad);
        return new NBTTagString(str);
    }

    public boolean tick() {
        if (this.lifetime <= 0) {
            if (FactoryTech.random.nextDouble() < this.breakChance) {
                return true;
            }
            this.breakChance *= this.increase;
        } else {
            --this.lifetime;
        }
        return false;
    }

    public boolean isBad() {
        return this.isBad;
    }

    public int getRemainingOperations() {
        return this.lifetime;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public double getSalvageChance() {
        return this.salvageChance;
    }
}

