/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.auxiliary;

import dalapo.factech.tileentity.TileEntityItemQueue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class QueuedItem {
    private ItemStack item;
    private int timeInQueue;
    private TileEntityItemQueue queue;
    private boolean isMoving;
    public static final QueuedItem EMPTY = new QueuedItem(ItemStack.field_190927_a, null, -1);

    public QueuedItem(ItemStack is, TileEntityItemQueue q) {
        this.item = is;
        this.queue = q;
        this.timeInQueue = 0;
    }

    public QueuedItem(ItemStack is, TileEntityItemQueue q, int startingTime) {
        this.item = is;
        this.queue = q;
        this.timeInQueue = startingTime;
    }

    public QueuedItem(NBTTagCompound nbt, TileEntityItemQueue q) {
        this.deserializeNBT(nbt);
        this.queue = q;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getTime() {
        return this.timeInQueue;
    }

    public void setTime(int time) {
        this.timeInQueue = time;
    }

    public boolean tick() {
        return ++this.timeInQueue >= this.queue.getCapacity();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = this.item.serializeNBT();
        nbt.func_74768_a("timeInQueue", this.timeInQueue);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.item = new ItemStack(nbt);
        this.timeInQueue = nbt.func_74764_b("timeInQueue") ? nbt.func_74762_e("timeInQueue") : 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueuedItem)) {
            return false;
        }
        return ((QueuedItem)o).item.equals(this.item) && ((QueuedItem)o).timeInQueue == this.timeInQueue;
    }
}

