/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.block;

import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.init.TabRegistry;
import dalapo.factech.reference.MachineInfoList;
import dalapo.factech.render.tesr.IAnimatedModel;
import dalapo.factech.tileentity.ActionOnRedstone;
import dalapo.factech.tileentity.TileEntityAnimatedModel;
import dalapo.factech.tileentity.TileEntityBasicInventory;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase
extends Block {
    protected boolean isFullBlock = true;
    private boolean showInCreative = true;
    protected final String name;
    private boolean hasInformation = false;
    private boolean hasComparatorOverride = false;
    private boolean hasCustomItem = false;
    private boolean redirectsRedstone = false;

    public BlockBase(Material materialIn, String name, boolean showInCreative, boolean hasComparatorOverride) {
        super(materialIn);
        this.name = name;
        this.showInCreative = showInCreative;
        this.hasComparatorOverride = hasComparatorOverride;
        this.func_149647_a(TabRegistry.FACTECH);
        this.func_149663_c("factorytech." + name);
        this.setRegistryName(name);
        this.func_149711_c(4.0f);
    }

    public BlockBase(Material materialIn, String name, boolean showInCreative) {
        this(materialIn, name, true, false);
    }

    public BlockBase(Material materialIn, String name) {
        this(materialIn, name, true);
    }

    public BlockBase setNonFullBlock() {
        this.isFullBlock = false;
        return this;
    }

    public BlockBase setHasInformation() {
        this.hasInformation = true;
        return this;
    }

    public BlockBase setHasCustomItem() {
        this.hasCustomItem = true;
        return this;
    }

    public BlockBase setRedirectsRedstone() {
        this.redirectsRedstone = true;
        return this;
    }

    public boolean getHasInformation() {
        return this.hasInformation;
    }

    public boolean hasCustomItem() {
        return this.hasCustomItem;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.redirectsRedstone;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack is, World world, List<String> list, ITooltipFlag flags) {
        super.func_190948_a(is, world, list, flags);
        if (this.hasInformation) {
            this.actuallyAddInformation(is, world, list, flags);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideOnly(value=Side.CLIENT)
    public void actuallyAddInformation(ItemStack is, World world, List<String> list, ITooltipFlag flags) {
        if (FacTechConfigManager.showTooltips && Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71462_r.func_146272_n()) {
                list.add(MachineInfoList.dictionary.get(this.name));
                list.add(I18n.func_135052_a((String)"factorytech.tooltip.seeblueprint", (Object[])new Object[0]).replaceAll("&", "\u00a7"));
                return;
            }
        }
        list.add(I18n.func_135052_a((String)"factorytech.tooltip.collapsed", (Object[])new Object[0]));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ActionOnRedstone) {
            ((ActionOnRedstone)te).onRedstoneSignal(world.func_175640_z(pos), EnumFacing.func_176737_a((float)(pos.func_177958_n() - fromPos.func_177958_n()), (float)(pos.func_177956_o() - fromPos.func_177956_o()), (float)(pos.func_177952_p() - fromPos.func_177952_p())));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBasicInventory) {
            for (int i = 0; i < ((TileEntityBasicInventory)te).func_70302_i_(); ++i) {
                EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, ((TileEntityBasicInventory)te).func_70301_a(i));
                world.func_72838_d((Entity)ei);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isFullBlock;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void initStaticModel() {
        this.initModel();
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", "factorytech".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this instanceof IAnimatedModel) {
            return new TileEntityAnimatedModel();
        }
        return super.createTileEntity(world, state);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        if (this instanceof IAnimatedModel) {
            return new TileEntityAnimatedModel();
        }
        return null;
    }
}

