/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.block;

import dalapo.factech.auxiliary.Wrenchable;
import dalapo.factech.block.BlockBase;
import dalapo.factech.helper.FacBlockHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.reference.StateList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDirectional
extends BlockBase
implements Wrenchable {
    private boolean useAlternatePlacementMethod = false;
    protected boolean planeLocked;
    public Set<EnumFacing> directionBlacklist = new HashSet<EnumFacing>();
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyInteger PART_ID = PropertyInteger.func_177719_a((String)"partid", (int)0, (int)16);

    public BlockDirectional(Material materialIn, String name, boolean locked) {
        super(materialIn, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(StateList.directions, (Comparable)EnumFacing.NORTH));
        this.planeLocked = locked;
    }

    public BlockDirectional blacklistDirection(EnumFacing dir) {
        this.directionBlacklist.add(dir);
        return this;
    }

    public void printInfo(EntityPlayer ep) {
    }

    public BlockDirectional useAltPlacement() {
        this.useAlternatePlacementMethod = true;
        return this;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing direction;
        if (this.useAlternatePlacementMethod) {
            direction = facing.func_176734_d();
        } else {
            EnumFacing enumFacing = direction = this.planeLocked ? FacMathHelper.getDirectionFromEntityXZ(pos, placer) : FacMathHelper.getDirectionFromEntity(pos, placer);
            if (placer.func_70093_af()) {
                direction = direction.func_176734_d();
            }
        }
        if (this.directionBlacklist.contains(direction)) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (this.directionBlacklist.contains(f)) continue;
                direction = f;
                break;
            }
        }
        return this.func_176223_P().func_177226_a(StateList.directions, (Comparable)direction);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{StateList.directions, PART_ID});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(StateList.directions)).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a(StateList.directions, (Comparable)EnumFacing.func_82600_a((int)meta)).func_177226_a((IProperty)PART_ID, (Comparable)Integer.valueOf(0));
    }

    @Override
    public void onWrenched(EntityPlayer ep, boolean isSneaking, World world, BlockPos pos, EnumFacing side) {
        EnumFacing newFacing = (EnumFacing)world.func_180495_p(pos).func_177229_b(StateList.directions);
        while (this.directionBlacklist.contains(newFacing = this.planeLocked ? newFacing.func_176746_e() : FacBlockHelper.nextRotation(newFacing, false))) {
        }
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a(StateList.directions, (Comparable)newFacing));
    }
}

