/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.block;

import dalapo.factech.FactoryTech;
import dalapo.factech.block.BlockDirectionalTile;
import dalapo.factech.helper.FacChatHelper;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.tileentity.TileEntityMachine;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends BlockDirectionalTile {
    private int GuiId;
    private boolean hasObjModel;
    private String desc;

    public BlockMachine(Material materialIn, String name, String teid, int gui) {
        this(materialIn, name, teid, gui, true);
    }

    public BlockMachine(Material materialIn, String name, String teid, int gui, boolean hasObjModel) {
        super(materialIn, name, teid, true);
        this.GuiId = gui;
        this.func_149711_c(4.0f);
        this.func_149752_b(4.0f);
        this.hasObjModel = hasObjModel;
    }

    public BlockMachine(Material material, String name, String teid) {
        this(material, name, teid, 0);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        EntityItem ei;
        int i;
        TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
        for (i = 0; i < te.getIO().getSlots(); ++i) {
            ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, te.getIO().getStackInSlot(i).func_77946_l());
            world.func_72838_d((Entity)ei);
        }
        for (i = 0; i < te.getParts().getSlots(); ++i) {
            ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, te.getParts().getStackInSlot(i).func_77946_l());
            world.func_72838_d((Entity)ei);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer ep, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (ep.func_70093_af() || ep.func_184614_ca().func_77973_b().equals(ItemRegistry.magnifyingGlass)) {
            return false;
        }
        if (ep.func_184614_ca().func_77973_b().equals(ItemRegistry.upgrade)) {
            if (!world.field_72995_K) {
                int upgrade = ep.func_184614_ca().func_77952_i() + 1;
                if (!ep.func_184812_l_()) {
                    ep.func_184614_ca().func_190918_g(1);
                }
                TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
                te.installUpgrade(upgrade);
                world.func_184138_a(pos, state, state, 3);
            }
            return true;
        }
        ep.openGui((Object)FactoryTech.instance, this.GuiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ep.field_71070_bA.func_75142_b();
        return true;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !this.hasObjModel;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public void onWrenched(EntityPlayer ep, boolean isSneaking, World world, BlockPos pos, EnumFacing side) {
        if (isSneaking) {
            TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
            te.setActualPartSide(side);
            if (world.field_72995_K) {
                FacChatHelper.sendChatToPlayer(ep, String.format("Part input side set to %s", side.toString()));
            }
        } else {
            super.onWrenched(ep, isSneaking, world, pos, side);
        }
    }
}

