/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.block;

import dalapo.factech.block.BlockTENoDir;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.reference.StateList;
import dalapo.factech.render.PipeBakedModel;
import dalapo.factech.render.UnlistedPropertyAdjacentBlock;
import dalapo.factech.tileentity.automation.TileEntityFluidPuller;
import dalapo.factech.tileentity.automation.TileEntityPipe;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPipe
extends BlockTENoDir {
    public static final UnlistedPropertyAdjacentBlock NORTH = new UnlistedPropertyAdjacentBlock("north");
    public static final UnlistedPropertyAdjacentBlock SOUTH = new UnlistedPropertyAdjacentBlock("south");
    public static final UnlistedPropertyAdjacentBlock EAST = new UnlistedPropertyAdjacentBlock("east");
    public static final UnlistedPropertyAdjacentBlock WEST = new UnlistedPropertyAdjacentBlock("west");
    public static final UnlistedPropertyAdjacentBlock UP = new UnlistedPropertyAdjacentBlock("up");
    public static final UnlistedPropertyAdjacentBlock DOWN = new UnlistedPropertyAdjacentBlock("down");

    public BlockPipe(Material materialIn, String name) {
        super(materialIn, name);
        this.func_149663_c("factorytech.pipe");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return PipeBakedModel.BAKED_MODEL;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    @SideOnly(value=Side.CLIENT)
    public void initInvModel() {
        Item itemBlock = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("factorytech", "pipe"));
        ModelResourceLocation loc = new ModelResourceLocation(this.getRegistryName(), "inventory");
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(itemBlock, 0, loc);
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listed = new IProperty[]{};
        IUnlistedProperty[] unlisted = new IUnlistedProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        return new ExtendedBlockState((Block)this, listed, unlisted);
    }

    private boolean shouldConnect(IBlockAccess world, BlockPos pos, EnumFacing direction) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())) {
            return true;
        }
        return te instanceof TileEntityFluidPuller && world.func_180495_p(pos).func_177229_b(StateList.directions) == direction.func_176734_d();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState stateEx = (IExtendedBlockState)state;
        boolean[] sameBlocks = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            sameBlocks[i] = this.shouldConnect(world, FacMathHelper.withOffset(pos, EnumFacing.func_82600_a((int)i)), EnumFacing.func_82600_a((int)i));
        }
        return stateEx.withProperty((IUnlistedProperty)DOWN, (Object)sameBlocks[0]).withProperty((IUnlistedProperty)UP, (Object)sameBlocks[1]).withProperty((IUnlistedProperty)NORTH, (Object)sameBlocks[2]).withProperty((IUnlistedProperty)SOUTH, (Object)sameBlocks[3]).withProperty((IUnlistedProperty)WEST, (Object)sameBlocks[4]).withProperty((IUnlistedProperty)EAST, (Object)sameBlocks[5]);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPipe();
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPipe();
    }
}

