/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.block;

import dalapo.factech.auxiliary.Wrenchable;
import dalapo.factech.block.BlockBase;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.init.BlockRegistry;
import dalapo.factech.init.ItemRegistry;
import dalapo.factech.reference.AABBList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockScaffold
extends BlockBase
implements Wrenchable {
    private static final int MAX_RECURSIONS = 256;

    public BlockScaffold(Material materialIn, String name) {
        super(materialIn, name);
        this.func_149711_c(0.5f);
        this.func_149752_b(2.0f);
        this.isFullBlock = false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABBList.COLUMN;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    private int dropAllScaffolds(World world, BlockPos pos, int recursions) {
        world.func_175655_b(pos, true);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            if (!world.func_180495_p(FacMathHelper.withOffset(pos, f)).equals(this.func_176223_P()) || recursions >= 256) continue;
            this.dropAllScaffolds(world, FacMathHelper.withOffset(pos, f), recursions + 1);
        }
        return 0;
    }

    private EnumFacing getDirFromHitCoords(float hX, float hZ) {
        float hitX = hX - 0.5f;
        float hitZ = hZ - 0.5f;
        if (hitZ < 0.0f && hitZ * hitZ > hitX * hitX) {
            return EnumFacing.NORTH;
        }
        if (hitX < 0.0f && hitX * hitX > hitZ * hitZ) {
            return EnumFacing.WEST;
        }
        if (hitZ > 0.0f && hitZ * hitZ > hitX * hitX) {
            return EnumFacing.SOUTH;
        }
        if (hitX > 0.0f && hitX * hitX > hitZ * hitZ) {
            return EnumFacing.EAST;
        }
        return EnumFacing.UP;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer ep, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(world, pos, state, ep, hand, side, hitX, hitY, hitZ);
        if (ep.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)this)) {
            BlockSnapshot snapshot;
            EnumFacing dirToMove;
            BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos(pos);
            EnumFacing enumFacing = dirToMove = side == EnumFacing.UP ? this.getDirFromHitCoords(hitX, hitZ) : EnumFacing.UP;
            while (world.func_180495_p((BlockPos)bp).func_177230_c() == this) {
                bp.func_189536_c(dirToMove);
            }
            if (world.func_175623_d((BlockPos)bp) && bp.func_177956_o() < 255 && world.func_175707_a((BlockPos)bp, (BlockPos)bp) && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.PlaceEvent(snapshot = new BlockSnapshot(world, (BlockPos)bp, this.func_176223_P()), this.func_176223_P(), ep, hand))) {
                world.func_175656_a((BlockPos)bp, this.func_176223_P());
                if (!ep.func_184812_l_()) {
                    ep.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
        }
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer ep) {
        if (ep.func_184614_ca().func_77973_b() == ItemRegistry.wrench && !world.field_72995_K) {
            int num = this.dropAllScaffolds(world, pos, 0);
            for (int fullStacks = 0; fullStacks < num / 64; ++fullStacks) {
                ItemStack is = new ItemStack((Block)BlockRegistry.scaffold, 64);
                world.func_72838_d((Entity)new EntityItem(world, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, is));
            }
            ItemStack is = new ItemStack((Block)BlockRegistry.scaffold, num % 64);
            world.func_72838_d((Entity)new EntityItem(world, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, is));
        } else {
            super.func_176208_a(world, pos, state, ep);
        }
    }

    @Override
    public void onWrenched(EntityPlayer ep, boolean isSneaking, World world, BlockPos pos, EnumFacing side) {
        if (isSneaking) {
            this.dropAllScaffolds(world, pos, 0);
        }
    }
}

