/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.block.fluid;

import dalapo.factech.auxiliary.IFluidModel;
import dalapo.factech.auxiliary.StateMap;
import dalapo.factech.helper.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSulphuricAcid
extends BlockFluidClassic
implements IFluidModel {
    public BlockSulphuricAcid(Fluid fluid, Material materialIn, String name) {
        super(fluid, materialIn);
        this.setRegistryName(name);
        this.density = 1000;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        Logger.info("Entered onEntityCollidedWithBlock");
        Logger.info(entity instanceof EntityLiving);
        if (entity instanceof EntityItem) {
            ItemStack is = ((EntityItem)entity).func_92059_d();
            NBTTagCompound nbt = is.func_77978_p();
            if (nbt != null && nbt.func_74764_b("ench")) {
                nbt.func_82580_o("ench");
            }
        } else if (entity instanceof EntityLivingBase) {
            entity.func_70097_a(new DamageSource("acid").func_76348_h(), 4.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", "factorytech".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        Item item = Item.func_150898_a((Block)this);
        StateMap map = new StateMap("factorytech", "fluid", "sulphuric_flowing");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)map);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)map);
    }
}

