/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.config;

import dalapo.factech.CommonProxy;
import dalapo.factech.auxiliary.MachinePart;
import dalapo.factech.auxiliary.MachineRecipes;
import dalapo.factech.config.MachineDefaults;
import dalapo.factech.helper.Logger;
import dalapo.factech.helper.Pair;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.TileEntityMachine;
import dalapo.factech.tileentity.TileEntityOldMachine;
import dalapo.factech.tileentity.specialized.TileEntityEnergizer;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class FacTechConfigManager {
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_CLIENT = "client";
    private static final String CATEGORY_MACHINES = "machines";
    private static final String CATEGORY_PARTS = "machineParts";
    public static int maxDecoCoilRange = 12;
    public static boolean genCopper = true;
    public static boolean genNickel = true;
    public static boolean convertParts = true;
    public static boolean allowMachineEnchanting = true;
    public static boolean restrictWaterCollectorBiomes = true;
    public static boolean disassemblePlayers = false;
    public static int maxPartStackSize = 4;
    public static boolean doTesrs = true;
    public static int maxWoodcutterRecursions = 256;
    public static float quarryChunkChance = 0.167f;
    public static int copperMin = 0;
    public static int copperMax = 48;
    public static int nickelMin = 0;
    public static int nickelMax = 24;
    public static float fluidDrillMultiplier = 1.0f;
    public static String grateBiomes;
    public static String[] grateOutputs;
    public static Map<Class<? extends TileEntityOldMachine>, MachinePart[]> allParts;
    public static Map<Class<? extends TileEntityMachine>, TileEntityMachine.MachinePartBlueprint[]> allPartsNew;
    public static boolean showTooltips;
    public static int batteryGeneratorOutput;
    public static int averageCoreGeneratorOutput;
    public static int itemsPerFruit;
    public static boolean doOverlay;

    public static String encodeMachinePart(MachinePart part) {
        return String.format("%s:%s:%s:%s:%s", part.id.getName(), part.getMinOperations(), Float.valueOf(part.getBaseChance()), Float.valueOf(part.getIncrease()), Float.valueOf(part.getSalvageChance()));
    }

    private static MachinePart decodeMachinePart(String part) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        String[] arr = part.split(":");
        PartList id = PartList.getPartFromString(arr[0]);
        int min = Integer.parseInt(arr[1]);
        float base = Float.parseFloat(arr[2]);
        float inc = Float.parseFloat(arr[3]);
        float salv = Float.parseFloat(arr[4]);
        return new MachinePart(id, base, inc, salv, min);
    }

    private static TileEntityMachine.MachinePartBlueprint decodeMachinePartNew(String part, float mul) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        String[] arr = part.split(":");
        PartList id = PartList.getPartFromString(arr[0]);
        int min = Integer.parseInt(arr[1]);
        float base = Float.parseFloat(arr[2]);
        float inc = Float.parseFloat(arr[3]);
        float salv = Float.parseFloat(arr[4]);
        return new TileEntityMachine.MachinePartBlueprint(id, (int)((float)min * mul), base, inc, salv);
    }

    public static void initMultipliers(Configuration cfg) {
        cfg.setCategoryComment("tileentityagitator", "Usage: minUses:breakChance:increase:salvageChance");
        float masterMultiplier = cfg.getFloat("masterMultiplier", "Universal", 1.0f, 0.0f, 100.0f, "Part lifespans in all machines are multiplied by this value");
        for (MachineDefaults def : MachineDefaults.values()) {
            String name = def.name();
            TileEntityMachine.MachinePartBlueprint[] partsNew = new TileEntityMachine.MachinePartBlueprint[def.partsNeeded.length];
            for (int i = 0; i < def.partsNeeded.length; ++i) {
                String encoded = cfg.getString(def.partsNeeded[i].id.getName(), def.name(), FacTechConfigManager.encodeMachinePart(def.partsNeeded[i]), "");
                partsNew[i] = FacTechConfigManager.decodeMachinePartNew(encoded, masterMultiplier);
            }
            allPartsNew.put(def.clazz, partsNew);
        }
    }

    public static void readConfig() {
        Configuration cfg = CommonProxy.config;
        Configuration cfgMachine = CommonProxy.machineConfig;
        try {
            cfg.load();
            FacTechConfigManager.initGeneralConfig(cfg);
            FacTechConfigManager.initClientConfig(cfg);
            FacTechConfigManager.initMachineConfig(cfg);
            FacTechConfigManager.initMultipliers(cfgMachine);
        }
        catch (Exception e) {
            Logger.error("Error reading config: " + e);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
            if (cfgMachine.hasChanged()) {
                cfgMachine.save();
            }
        }
    }

    public static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        genCopper = cfg.getBoolean("genCopper", CATEGORY_GENERAL, true, "Set to false to disable copper ore generation");
        copperMin = cfg.getInt("copperMin", CATEGORY_GENERAL, 0, 0, 256, "Minimum y-level that copper can generate");
        copperMax = cfg.getInt("copperMax", CATEGORY_GENERAL, 48, 0, 256, "Maximum y-level that copper can generate");
        genNickel = cfg.getBoolean("genNickel", CATEGORY_GENERAL, true, "Set to false to disable nickel ore generation");
        nickelMin = cfg.getInt("nickelMin", CATEGORY_GENERAL, 0, 0, 256, "Minimum y-level that nickel can generate");
        nickelMax = cfg.getInt("nickelMax", CATEGORY_GENERAL, 24, 0, 256, "Minimum y-level that nickel can generate");
        fluidDrillMultiplier = cfg.getFloat("fluidDrillMultiplier", CATEGORY_GENERAL, 1.0f, 0.01f, 10.0f, "Fluid Extraction Drill output multiplier");
        maxDecoCoilRange = cfg.getInt("maxDecoCoilRange", CATEGORY_GENERAL, 12, 1, Integer.MAX_VALUE, "Maximum distance in blocks that decorative coils can connect to each other");
        itemsPerFruit = cfg.getInt("itemsPerFruit", CATEGORY_GENERAL, 8, 0, 576, "Number of items that the Dimensional Shifter can send using a single piece of Chorus Fruit");
    }

    public static void initClientConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_CLIENT, "Client configuration");
        doTesrs = cfg.getBoolean("doTESRs", CATEGORY_CLIENT, true, "Set to false to disable machine animations; this will make the mod uglier but may increase your framerate");
        showTooltips = cfg.getBoolean("showTooltips", CATEGORY_CLIENT, true, "Set to false to disable extra information in machine tooltips.");
        doOverlay = cfg.getBoolean("doOverlay", CATEGORY_CLIENT, true, "Set to false to disable the Magnifying Glass overlay which may be redundant with WAILA and similar mods.");
    }

    public static void initMachineConfig(Configuration cfg) {
        String[] blacklist;
        allowMachineEnchanting = cfg.getBoolean("allowGrinderEnchanting", CATEGORY_MACHINES, true, "Set to false to disable the Grindstone enchanting tools and weapons");
        disassemblePlayers = cfg.getBoolean("disassemblePlayers", CATEGORY_MACHINES, false, "Set to true to allow the Mob Disassembler to attack players");
        grateBiomes = cfg.getString("riverGrateWhitelist", CATEGORY_MACHINES, "7", "A list of biome IDs the River Grate is allowed to function in, separated by commas. Enter \"all\" instead to allow every biome.");
        restrictWaterCollectorBiomes = cfg.getBoolean("restrictWaterCollectorBiomes", CATEGORY_MACHINES, true, "Set to false to allow the Water Collector to run in any biome");
        maxWoodcutterRecursions = cfg.getInt("maxWoodcutterRecursions", CATEGORY_MACHINES, 256, 1, 65536, "Maximum number of logs the Woodcutter can break at once. Higher values may cause lag spikes or crashes.");
        maxPartStackSize = cfg.getInt("maxPartStackSize", CATEGORY_MACHINES, 4, 1, 64, "Maximum stack size for parts");
        quarryChunkChance = cfg.getFloat("quarryChunkChance", CATEGORY_MACHINES, 0.167f, 0.0f, 1.0f, "Chance per block broken for Mining Machines to output an Ore Chunk");
        batteryGeneratorOutput = cfg.getInt("batteryGeneratorOutput", CATEGORY_MACHINES, 30, 0, 600, "RF/t output of the Electric Dynamo");
        averageCoreGeneratorOutput = cfg.getInt("averageCoreGeneratorOutput", CATEGORY_MACHINES, 120, 0, 6000, "Average RF/t output of the Core Conversion Dynamo");
        for (String str : blacklist = cfg.getStringList("energizerBlacklist", CATEGORY_MACHINES, new String[]{"dalapo.factech.tileentity.specialized.TileEntityEnergizer"}, "Full names of Tile Entities to be ignored by the Universal Supercharger.")) {
            TileEntityEnergizer.blacklistTileEntity(str);
        }
    }

    public static void initDeepDrillCustomOres() {
        String[] stacks;
        Configuration cfg = CommonProxy.config;
        for (String str : stacks = cfg.getStringList("deepDrillCustomOres", CATEGORY_MACHINES, new String[0], "Add extra ores to the Terraneous Extractor table according to their Ore Dict entry and weight. Coal ore has weight 2.0, Diamond has weight 0.1. Example: oreTin:1.5")) {
            String[] entry = str.split(":");
            if (OreDictionary.getOres((String)entry[0]).isEmpty()) continue;
            try {
                MachineRecipes.DEEP_DRILL.add(new Pair<Object, Double>(OreDictionary.getOres((String)entry[0]).get(0), Double.parseDouble(entry[1])));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    static {
        allParts = new HashMap<Class<? extends TileEntityOldMachine>, MachinePart[]>();
        allPartsNew = new HashMap<Class<? extends TileEntityMachine>, TileEntityMachine.MachinePartBlueprint[]>();
        showTooltips = true;
        batteryGeneratorOutput = 30;
        averageCoreGeneratorOutput = 120;
        itemsPerFruit = 8;
        doOverlay = true;
    }
}

