/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.entity;

import dalapo.factech.helper.FacChatHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.init.ModFluidRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EntityPressureGunShot
extends EntityArrow {
    private EnumPressureGun projType = EnumPressureGun.AIR;
    private EntityLivingBase owner;
    private boolean isFresh;
    private int bX = -1;
    private int bY = -1;
    private int bZ = -1;
    private double distTravelled = 0.0;
    private int age = 0;

    public EntityPressureGunShot(World world) {
        super(world);
    }

    public EntityPressureGunShot(World worldIn, EntityLivingBase shooter, int fluidType, boolean flag) {
        super(worldIn);
        this.owner = shooter;
        this.isFresh = flag;
        this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
        try {
            this.projType = EnumPressureGun.values()[fluidType];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.warn("PRESSURE GUN: Array index out of bounds: " + fluidType);
            this.projType = EnumPressureGun.AIR;
        }
    }

    public Fluid getFluid() {
        switch (this.projType) {
            case WATER: {
                return FluidRegistry.WATER;
            }
            case H2SO4: {
                return ModFluidRegistry.h2so4;
            }
            case PROPANE: {
                return FluidRegistry.LAVA;
            }
            case GLOWSTONE: {
                return ModFluidRegistry.glowstone;
            }
            case SULPHUR: {
                return ModFluidRegistry.sulphur;
            }
            case ENERGITE: {
                return ModFluidRegistry.energite;
            }
        }
        return null;
    }

    public void func_184549_a(RayTraceResult raytrace) {
        if (raytrace.field_72308_g instanceof EntityLiving && raytrace.field_72308_g != this.owner) {
            EntityLiving entityHit = (EntityLiving)raytrace.field_72308_g;
            if (this.projType.damage > 0 && !(entityHit instanceof EntitySquid)) {
                entityHit.func_70097_a((DamageSource)new EntityDamageSource(this.isFresh ? "splat" : "fluidgun", (Entity)this.owner){

                    @Nullable
                    public Vec3d func_188404_v() {
                        return null;
                    }
                }, (float)this.projType.damage);
            }
            Vec3d knockback = new Vec3d(this.field_70159_w, this.field_70181_x + 0.2, this.field_70179_y).func_72432_b().func_186678_a((double)this.projType.knockback);
            if (entityHit.field_70737_aN == 0) {
                entityHit.func_70024_g(knockback.field_72450_a, knockback.field_72448_b, knockback.field_72449_c);
            }
            for (PotionEffect effect : this.projType.effects) {
                entityHit.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c()));
            }
            if (this.projType.fire) {
                entityHit.func_70015_d(5);
            }
            if (entityHit.func_110143_aJ() <= 0.0f && this.owner instanceof EntityPlayer && this.isFresh) {
                FacChatHelper.sendChatToPlayer((EntityPlayer)this.owner, I18n.func_135052_a((String)"factorytech.pressuregun.splat", (Object[])new Object[]{entityHit.func_70005_c_()}));
            }
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        this.func_70030_z();
        BlockPos blockpos = new BlockPos(this.bX, this.bY, this.bZ);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70254_i) {
            this.func_70106_y();
        } else {
            Entity entity;
            ++this.age;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null) {
                this.func_184549_a(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.distTravelled += FacMathHelper.pyth3D(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            if (this.projType.gravity) {
                this.field_70181_x -= 0.02;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
        if (this.field_70254_i || this.distTravelled > (double)this.projType.range) {
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("fluidType")) {
            this.projType = EnumPressureGun.values()[compound.func_74762_e("fluidType")];
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("fluidType", this.projType.ordinal());
    }

    public EnumPressureGun getProjType() {
        return this.projType;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    private EnumParticleTypes getParticle() {
        return EnumParticleTypes.WATER_SPLASH;
    }

    public boolean func_70241_g() {
        return false;
    }

    public static enum EnumPressureGun {
        AIR("air", 0, 1.5f, 6, 0.2, false, false, new PotionEffect[0]),
        WATER("water", 1, 1.0f, 15, 0.0, false, true, new PotionEffect[0]),
        PROPANE("propane", 5, 0.75f, 8, 0.15, true, false, new PotionEffect[0]),
        H2SO4("h2so4", 8, 0.5f, 9, 0.1, false, true, new PotionEffect(MobEffects.field_76429_m, 120, -1)),
        SULPHUR("sulphur", 4, 0.5f, 10, 0.15, false, true, new PotionEffect(MobEffects.field_76421_d, 100, 2), new PotionEffect(MobEffects.field_76437_t, 100, 2), new PotionEffect(MobEffects.field_76431_k, 120, 1)),
        GLOWSTONE("glowstone", 1, 0.0f, 8, 0.05, false, true, new PotionEffect(MobEffects.field_188423_x, 200, 1)),
        ENERGITE("energite", 6, 0.75f, 10, 0.075, false, true, new PotionEffect(MobEffects.field_76436_u, 160, 3));

        public final String name;
        public final int damage;
        public final float knockback;
        public final int range;
        public final double spread;
        public final boolean fire;
        public final boolean gravity;
        public final PotionEffect[] effects;

        private EnumPressureGun(String name, int damage, float knockback, int range, double spread, boolean fire, boolean gravity, PotionEffect ... effects) {
            this.name = name;
            this.damage = damage;
            this.knockback = knockback;
            this.range = range;
            this.spread = spread;
            this.fire = fire;
            this.gravity = gravity;
            this.effects = effects;
        }
    }
}

