/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.gui;

import dalapo.factech.gui.ContainerBasicMachine;
import dalapo.factech.gui.GuiFacInventory;
import dalapo.factech.helper.FacGuiHelper;
import dalapo.factech.reference.PartList;
import dalapo.factech.tileentity.TileEntityMachine;
import java.awt.Point;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiBasicMachine
extends GuiFacInventory {
    String name;
    protected TileEntityMachine te;
    IInventory playerInv;
    private int barX;
    private int barY;

    public GuiBasicMachine(ContainerBasicMachine inventorySlotsIn, IInventory player, String id, TileEntityMachine te) {
        super(inventorySlotsIn);
        this.name = id;
        this.te = te;
        this.playerInv = player;
    }

    @Override
    public TileEntityMachine getTile() {
        return this.te;
    }

    public GuiBasicMachine(ContainerBasicMachine inventorySlotsIn, IInventory player, TileEntityMachine te) {
        this(inventorySlotsIn, player, "basicmachine", te);
    }

    protected TileEntityMachine getMachine() {
        return this.te;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void drawInvSquare(int x, int y) {
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 176, 11, 18, 18);
    }

    protected Point getPartLocation(PartList part) {
        switch (part) {
            case BATTERY: {
                return new Point(0, 0);
            }
            case BLADE: {
                return new Point(15, 0);
            }
            case CIRCUIT_0: {
                return new Point(45, 0);
            }
            case CIRCUIT_1: {
                return new Point(60, 0);
            }
            case CIRCUIT_2: {
                return new Point(75, 0);
            }
            case CIRCUIT_3: {
                return new Point(90, 0);
            }
            case CORE: {
                return new Point(105, 0);
            }
            case DRILL: {
                return new Point(120, 0);
            }
            case GEAR: {
                return new Point(135, 0);
            }
            case HEATELEM: {
                return new Point(150, 0);
            }
            case MAGNET: {
                return new Point(165, 0);
            }
            case MESH: {
                return new Point(180, 0);
            }
            case MIXER: {
                return new Point(195, 0);
            }
            case MOTOR: {
                return new Point(210, 0);
            }
            case PISTON: {
                return new Point(225, 0);
            }
            case SAW: {
                return new Point(240, 0);
            }
            case SHAFT: {
                return new Point(0, 15);
            }
            case WIRE: {
                return new Point(15, 15);
            }
            case LENS: {
                return new Point(30, 15);
            }
        }
        return new Point(256, 256);
    }

    public GuiBasicMachine setBarCoords(int barX, int barY) {
        this.barX = barX;
        this.barY = barY;
        return this;
    }

    protected void drawProgressBar() {
        int progress = this.te.getProgressScaled(21);
        this.func_73729_b(this.field_147003_i + this.barX, this.field_147009_r + this.barY, 176, 0, progress, 11);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(FacGuiHelper.formatTexName(this.name)));
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawProgressBar();
        for (i = 0; i < this.te.countPartSlots(); ++i) {
            this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 7 + i * 18, 176, 11, 18, 18);
        }
        for (i = 0; i < this.te.countPartSlots(); ++i) {
            ResourceLocation itemSprite = new ResourceLocation(FacGuiHelper.formatTexName("part_spritesheet"));
            this.field_146297_k.func_110434_K().func_110577_a(itemSprite);
            Point p = this.getPartLocation(this.te.getPartsNeeded()[i]);
            this.func_73729_b(this.field_147003_i + 134, this.field_147009_r + 8 + i * 18, p.x, p.y, 16, 16);
        }
        for (i = 0; i < this.te.countPartSlots(); ++i) {
            int colour;
            if (!this.te.hasPart(i)) {
                GuiBasicMachine.func_73734_a((int)(this.field_147003_i + 134), (int)(this.field_147009_r + 7 + i * 18), (int)(this.field_147003_i + 152), (int)(this.field_147009_r + 25 + i * 18), (int)-2130771968);
                continue;
            }
            double percentage = MathHelper.func_151237_a((double)this.te.getLifetimeRatio(i), (double)0.0, (double)1.0);
            int n = percentage > 0.5 ? -16711936 : (colour = percentage > 0.25 ? Short.MIN_VALUE : -65536);
            if (percentage > 0.0) {
                GuiBasicMachine.func_73734_a((int)(this.field_147003_i + 130), (int)(this.field_147009_r + i * 18 + 25 - (int)(18.0 * percentage)), (int)(this.field_147003_i + 134), (int)(this.field_147009_r + 25 + i * 18), (int)colour);
                continue;
            }
            GuiBasicMachine.func_73734_a((int)(this.field_147003_i + 130), (int)(this.field_147009_r + i * 18 + 7), (int)(this.field_147003_i + 134), (int)(this.field_147009_r + 25 + i * 18), (int)-12582912);
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String str = this.te.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(str, 88 - this.field_146289_q.func_78256_a(str) / 2, 6, 0x404040);
    }
}

