/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.gui;

import dalapo.factech.gui.ContainerBasicMachine;
import dalapo.factech.gui.GuiBasicMachine;
import dalapo.factech.helper.FacGuiHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.packet.CircuitScribePacket;
import dalapo.factech.packet.PacketHandler;
import dalapo.factech.tileentity.TileEntityMachine;
import dalapo.factech.tileentity.specialized.TileEntityCircuitScribe;
import java.io.IOException;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class GuiCircuitScribe
extends GuiBasicMachine {
    private TileEntityCircuitScribe scribe;
    private boolean[][] board;
    private boolean isValidPattern = false;
    private final int boardLeft = 32;
    private final int boardTop = 98;

    public GuiCircuitScribe(ContainerBasicMachine inventorySlotsIn, IInventory player, TileEntityMachine te) {
        super(inventorySlotsIn, player, "circscribe_gui", te);
        this.scribe = (TileEntityCircuitScribe)te;
        this.field_147000_g = 200;
    }

    public static boolean[][] getBoard(int pattern) {
        switch (pattern) {
            case 0: {
                return new boolean[][]{{false, true, false, true, false}, {true, true, true, true, true}, {false, false, true, false, true}, {false, true, true, true, false}, {true, true, false, true, true}, {false, true, true, true, false}};
            }
            case 1: {
                return new boolean[][]{{false, false, true, false, false}, {false, false, true, false, false}, {false, true, true, true, false}, {false, true, false, true, false}, {true, true, true, true, true}, {true, false, true, false, true}};
            }
            case 2: {
                return new boolean[][]{{false, false, false, true, false}, {false, true, true, true, false}, {false, true, false, true, true}, {true, true, false, true, false}, {false, true, false, false, false}, {false, true, true, true, false}};
            }
            case 3: {
                return new boolean[][]{{false, true, false, true, true}, {true, true, true, true, false}, {true, false, false, true, true}, {true, true, true, true, false}, {true, false, true, false, false}, {true, false, true, false, false}};
            }
        }
        return new boolean[6][5];
    }

    private byte getMatch() {
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            boolean matches = true;
            boolean[][] boardTest = GuiCircuitScribe.getBoard(i);
            if (boardTest.length != this.board.length || boardTest[0].length != this.board[0].length) {
                return -1;
            }
            for (int row = 0; row < this.board.length; ++row) {
                for (int col = 0; col < this.board[row].length; ++col) {
                    if (this.board[row][col] == boardTest[row][col]) continue;
                    matches = false;
                }
            }
            if (!matches) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void drawProgressBar() {
        int progress = this.scribe.getProgressScaled(21);
        this.func_73729_b(this.field_147003_i + 11, this.field_147009_r + 47, 194, 0, 14, progress);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.board = GuiCircuitScribe.getBoard(this.scribe.getPattern());
        this.isValidPattern = this.getMatch() != -1;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (int x = 0; x < this.board.length * 16; x += 16) {
            for (int y = 0; y < this.board[x / 16].length * 16; y += 16) {
                if (this.board[x / 16][y / 16]) {
                    GuiCircuitScribe.func_73734_a((int)(32 + x), (int)(98 - y), (int)(32 + x + 16), (int)(98 - y - 16), (int)-8355712);
                    continue;
                }
                GuiCircuitScribe.func_73734_a((int)(32 + x), (int)(98 - y), (int)(32 + x + 16), (int)(98 - y - 16), (int)-1);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(FacGuiHelper.formatTexName(this.name)));
        if (this.isValidPattern) {
            this.func_73729_b(152, 90, 178, 52, 18, 12);
        } else {
            this.func_73729_b(152, 90, 178, 68, 18, 18);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        byte match;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int boardLeft = this.boardLeft + this.field_147003_i;
        int boardTop = this.boardTop + this.field_147009_r;
        if (FacMathHelper.isInRange(mouseX, boardLeft, boardLeft + 95) && FacMathHelper.isInRange(mouseY, boardTop - 79, boardTop)) {
            int modX = mouseX - boardLeft;
            int modY = boardTop - mouseY;
            boolean bl = this.board[modX / 16][modY / 16] = !this.board[modX / 16][modY / 16];
        }
        if ((match = this.getMatch()) != -1) {
            this.scribe.setPattern(match);
            this.isValidPattern = true;
            PacketHandler.sendToServer(new CircuitScribePacket(this.scribe));
        } else {
            this.isValidPattern = false;
        }
        this.func_146979_b(mouseX, mouseY);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.getMatch() == -1) {
            this.scribe.setPattern((byte)-1);
            PacketHandler.sendToServer(new CircuitScribePacket(this.scribe));
        }
    }
}

