/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.gui.handbook;

import dalapo.factech.FactoryTech;
import dalapo.factech.gui.handbook.GuiHandbookBase;
import dalapo.factech.gui.handbook.GuiHandbookPage;
import dalapo.factech.gui.handbook.GuiHandbookSubmenu;
import dalapo.factech.gui.handbook.HandbookEntry;
import dalapo.factech.gui.widget.WidgetCustomButton;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiHandbook
extends GuiHandbookBase {
    protected static final int GRID_X_OFFSET = 124;
    protected static final int GRID_Y_OFFSET = 96;
    private static int[] backgroundLookup = new int[64];
    public static List<ArrayList<HandbookEntry>> entries = new ArrayList<ArrayList<HandbookEntry>>();
    public static Map<String, IRecipe[]> recipes = new HashMap<String, IRecipe[]>();
    private ItemStack book;
    private static final int[] pageCounts = new int[7];
    private boolean drawGrid = false;
    private boolean drawBoard = false;
    private ItemStack[][] recipe;
    private boolean[][] board;
    private ItemStack result;
    GuiButton[] buttons = new GuiButton[10];
    int page = 0;
    int entry = 0;
    int numPages = 0;
    int section = -1;
    private static final String[] submenuNames = new String[]{"The Basics", "Machine info", "Part specifications", "Tools and Devices", "Automation components", "Resources", "Miscellaneous"};

    public static void initBackgrounds() {
        for (int i = 0; i < backgroundLookup.length; ++i) {
            GuiHandbook.backgroundLookup[i] = FactoryTech.random.nextInt(4);
        }
    }

    public static void setPageCount(int section, int count) {
        if (FacMathHelper.isInRange(section, 0, pageCounts.length)) {
            GuiHandbook.pageCounts[section] = count;
        }
    }

    public GuiHandbook(ItemStack is) {
        this.book = is;
        if (is.func_77942_o()) {
            NBTTagCompound nbt = is.func_77978_p();
            this.section = nbt.func_74764_b("section") ? nbt.func_74762_e("section") : -1;
            this.page = nbt.func_74762_e("page");
        }
        this.recipe = new ItemStack[3][3];
        this.resetGrid();
    }

    public GuiHandbook(EntityPlayer ep) {
        this(ep.func_184614_ca());
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!this.book.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("section", this.section);
            nbt.func_74768_a("page", this.page);
            nbt.func_74768_a("entry", this.entry);
            this.book.func_77982_d(nbt);
        } else {
            this.book.func_77978_p().func_74768_a("section", this.section);
            this.book.func_77978_p().func_74768_a("page", this.page);
            this.book.func_77978_p().func_74768_a("entry", this.entry);
        }
    }

    private void resetGrid() {
        recipes.clear();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.recipe[i][j] = ItemStack.field_190927_a;
            }
        }
        this.result = ItemStack.field_190927_a;
    }

    @Override
    public void func_73866_w_() {
        this.showMenu(0);
        this.section = -1;
        this.section = -1;
        if (this.book.func_77942_o()) {
            NBTTagCompound nbt = this.book.func_77978_p();
            int s = nbt.func_74762_e("section");
            int e = nbt.func_74762_e("entry");
            int p = nbt.func_74762_e("page");
            if (s != -1) {
                this.goToPage(s, e, p);
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton b : this.field_146292_n) {
            if (!b.field_146125_m) continue;
            b.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    private void showMenu(int menuID) {
        String[] names = new String[]{"The Basics", "Machine info", "Part specifications", "Tools and Devices", "Automation components", "Resources", "Miscellaneous"};
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 160) / 2;
        for (int i = 0; i < names.length; ++i) {
            this.buttons[i] = new WidgetCustomButton(this, i, this.guiLeft + 66, this.guiTop + 28 + i * 14, 120, 12, names[i], "button_handbook");
            this.func_189646_b(this.buttons[i]);
        }
    }

    public void func_146284_a(GuiButton b) {
        this.field_146292_n.clear();
        this.section = b.field_146127_k;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiHandbookSubmenu(submenuNames[b.field_146127_k], FactoryTech.random.nextInt(4), b.field_146127_k, 0, (List<HandbookEntry>)entries.get(b.field_146127_k), this));
    }

    protected void setSection(int s) {
        this.section = s;
    }

    protected void setEntry(int e) {
        this.entry = e;
    }

    protected void setPage(int p) {
        this.page = p;
    }

    private void goToPage(int section, int entry, int page) {
        Logger.info(String.format("Going to section %s entry %s page %s", section, entry, page));
        this.section = section;
        this.page = page;
        this.entry = entry;
        GuiHandbookSubmenu submenu = new GuiHandbookSubmenu(submenuNames[section], FactoryTech.random.nextInt(4), section, 0, (List<HandbookEntry>)entries.get(section), this);
        if (entry == -1) {
            submenu.changePage(page);
            this.field_146297_k.func_147108_a((GuiScreen)submenu);
        } else {
            GuiHandbookPage bookPage = new GuiHandbookPage(submenu.getEntry(entry), submenu);
            bookPage.page = page;
            this.field_146297_k.func_147108_a((GuiScreen)bookPage);
        }
    }
}

