/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.gui.handbook;

import dalapo.factech.FactoryTech;
import dalapo.factech.config.FacTechConfigManager;
import dalapo.factech.config.MachineDefaults;
import dalapo.factech.gui.GuiCircuitScribe;
import dalapo.factech.gui.handbook.GuiHandbookBase;
import dalapo.factech.gui.handbook.GuiHandbookSubmenu;
import dalapo.factech.gui.handbook.HandbookEntry;
import dalapo.factech.helper.FacGuiHelper;
import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.FacMiscHelper;
import dalapo.factech.tileentity.TileEntityMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;

public class GuiHandbookPage
extends GuiHandbookBase {
    protected static final int GRID_X_OFFSET = 80;
    protected static final int GRID_Y_OFFSET = 40;
    protected String title;
    protected int page = 0;
    protected int lastPage;
    protected String machineClass;
    protected List<String> text = new ArrayList<String>();
    protected List<IRecipe> recipes = new ArrayList<IRecipe>();
    protected ItemStack[][] recipe = new ItemStack[3][3];
    protected ItemStack result = ItemStack.field_190927_a;
    protected GuiHandbookSubmenu parent;

    public GuiHandbookPage(HandbookEntry entry, GuiHandbookSubmenu parent) {
        this.title = entry.title;
        this.text.addAll(entry.pages);
        this.recipes.addAll(entry.recipe);
        this.parent = parent;
        this.machineClass = entry.machine;
        this.resetGrid();
        if (this.machineClass != null && !this.machineClass.isEmpty()) {
            this.text.add(this.getPartSpecs());
        }
        this.lastPage = this.text.size() - 1;
        if (!this.recipes.isEmpty()) {
            ++this.lastPage;
        }
    }

    private boolean[][] getCircuitBoard(int pattern) {
        return GuiCircuitScribe.getBoard(pattern);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, this.guiLeft + 24, this.guiTop + 136, 20, 20, "X"));
        this.field_146292_n.add(new GuiButton(1, this.guiLeft + 4, this.guiTop + 136, 20, 20, "<"));
        this.field_146292_n.add(new GuiButton(2, this.guiLeft + 44, this.guiTop + 136, 20, 20, ">"));
        ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = this.page != 0;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.page != this.lastPage;
    }

    public void func_146281_b() {
        this.parent.func_146281_b();
    }

    public void func_146284_a(GuiButton b) {
        if (b.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
        } else if (b.field_146127_k == 1 && this.page != 0) {
            --this.page;
        } else if (b.field_146127_k == 2 && this.page < this.lastPage) {
            ++this.page;
        }
        this.parent.getParent().setPage(this.page);
        this.background = FactoryTech.random.nextInt(4);
        ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = this.page != 0;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.page != this.lastPage;
    }

    private String describePart(TileEntityMachine.MachinePartBlueprint part) {
        return String.format("%s: Min %s ops, %s break chance, %s increase, %s salvage\n", FacMiscHelper.capitalizeFirstLetter(part.id.getName()).replace('_', ' '), part.startingLife, Float.valueOf(part.chance), Float.valueOf(part.increase), Float.valueOf(part.salvageRate));
    }

    private String getPartSpecs() {
        MachineDefaults md = MachineDefaults.getFromString(this.machineClass);
        int numParts = md.partsNeeded.length;
        TileEntityMachine.MachinePartBlueprint[] toCopy = FacTechConfigManager.allPartsNew.get(md.clazz);
        String str = "Parts Needed:\n\n";
        for (int i = 0; i < toCopy.length; ++i) {
            str = str + this.describePart(toCopy[i]) + '\n';
        }
        return str;
    }

    protected void showRecipes() {
        if (this.recipes.size() != 0) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.recipe[i][j] = ItemStack.field_190927_a;
                }
            }
            IRecipe recipe = this.recipes.get((int)(System.currentTimeMillis() / 1000L % (long)this.recipes.size()));
            block4: for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    try {
                        ItemStack is;
                        if (((Ingredient)recipe.func_192400_c().get(row * 3 + col)).func_193365_a().length <= 0) continue;
                        this.recipe[row][col] = is = ((Ingredient)recipe.func_192400_c().get(row * 3 + col)).func_193365_a()[0];
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException | NullPointerException ex) {
                        continue block4;
                    }
                }
            }
            this.result = recipe.func_77571_b();
        } else {
            this.resetGrid();
        }
    }

    public void resetGrid() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.recipe[i][j] = ItemStack.field_190927_a;
            }
        }
        this.result = ItemStack.field_190927_a;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.page < this.text.size()) {
            this.field_146289_q.func_78276_b(this.title, this.guiLeft + 4, this.guiTop + 4, -1);
            this.field_146289_q.func_78279_b(this.text.get(this.page), this.guiLeft + 4, this.guiTop + 16, 248, -1);
        }
        if (this.title.equals("Circuit Board") && FacMathHelper.isInRangeInclusive(this.page, 2, 5)) {
            int boardLeft = this.guiLeft + 64;
            int boardTop = this.guiTop + 120;
            boolean[][] board = this.getCircuitBoard(this.page - 2);
            for (int x = 0; x < board.length * 16; x += 16) {
                for (int y = 0; y < board[x / 16].length * 16; y += 16) {
                    if (board[x / 16][y / 16]) {
                        GuiHandbookPage.func_73734_a((int)(boardLeft + x), (int)(boardTop - y), (int)(boardLeft + x + 16), (int)(boardTop - y - 16), (int)-8355712);
                        continue;
                    }
                    GuiHandbookPage.func_73734_a((int)(boardLeft + x), (int)(boardTop - y), (int)(boardLeft + x + 16), (int)(boardTop - y - 16), (int)-1);
                }
            }
        }
        if (this.recipes.size() > 0 && this.page == this.lastPage) {
            this.showRecipes();
            FacGuiHelper.bindTex("handbook_gui_0");
            this.func_73729_b(this.guiLeft + 80 - 1, this.guiTop + 40 - 1, 0, 160, 116, 54);
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    FacGuiHelper.renderItemStack(this.recipe[row][col], this.guiLeft + col * 18 + 80, this.guiTop + row * 18 + 40);
                    if (!FacMathHelper.isInRange(mouseX, col * 18 + 80, (col + 1) * 18 + 80) || !FacMathHelper.isInRange(mouseY, row * 18 + 40, (row + 1) * 18 + 40)) continue;
                    this.field_73735_i -= 1.0f;
                    this.func_146279_a(this.recipe[row][col].func_82833_r(), mouseX, mouseY);
                }
            }
            FacGuiHelper.renderItemStack(this.result, this.guiLeft + 94 + 80, this.guiTop + 18 + 40);
        }
    }
}

