/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.gui.widget;

import dalapo.factech.auxiliary.IHasFluid;
import dalapo.factech.gui.GuiTileEntity;
import dalapo.factech.gui.widget.FacTechWidget;
import dalapo.factech.helper.FacFluidRenderHelper;
import dalapo.factech.helper.FacGuiHelper;
import dalapo.factech.packet.FluidTankEmptyPacket;
import dalapo.factech.packet.PacketHandler;
import dalapo.factech.tileentity.TileEntityBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class WidgetFluidTank
extends FacTechWidget {
    private final FluidTank tank;
    private int tankID;

    public WidgetFluidTank(GuiTileEntity parent, int x, int y, int w, int h, FluidTank tank, int tankID) {
        super(parent, x, y, w, h);
        this.tank = tank;
        this.tankID = tankID;
    }

    @Override
    public void init() {
    }

    @Override
    public void handle(int mouseX, int mouseY, int mouseButton, boolean shift) {
        TileEntityBase te;
        if (shift && (te = this.parent.getTile()) instanceof IHasFluid) {
            ((IHasFluid)((Object)te)).overrideTank(null, this.tankID);
            PacketHandler.sendToServer(new FluidTankEmptyPacket(te, this.tankID));
        }
    }

    @Override
    public void draw(int parX, int parY) {
        FluidStack fluid = this.tank.getFluid();
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite fluidSprite = FacFluidRenderHelper.getSprite(fluid, false);
        if (fluidSprite == null) {
            return;
        }
        float ratio = (float)fluid.amount / (float)this.tank.getCapacity();
        FacGuiHelper.bindTex(TextureMap.field_110575_b);
        FacGuiHelper.setColor(fluid.getFluid().getColor());
        this.func_175175_a(this.x + parX, this.y + parY + 3 - (int)((float)this.height * ratio), fluidSprite, this.width, (int)((float)this.height * ratio));
    }

    @Override
    public String getTooltip() {
        if (this.tank.getFluidAmount() == 0) {
            return "Empty";
        }
        return this.tank.getFluid().getLocalizedName() + " (" + this.tank.getFluidAmount() + " mB)";
    }

    @Override
    public boolean isPointInBounds(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y - this.height + 3 && y <= this.y + 3;
    }
}

