/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.gui.widget;

import dalapo.factech.gui.GuiTileEntity;
import dalapo.factech.gui.widget.FacTechWidget;
import dalapo.factech.helper.FacGuiHelper;
import dalapo.factech.helper.Logger;
import dalapo.factech.packet.NumberEntryPacket;
import dalapo.factech.packet.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class WidgetNumberEntry
extends FacTechWidget {
    private int val;
    private final int min;
    private final int max;
    private byte fieldNum;
    private String tooltip;

    public WidgetNumberEntry(GuiTileEntity parent, String tooltip, int fieldNum, int x, int y, int min, int max) {
        super(parent, x, y, 18, 29);
        this.fieldNum = (byte)fieldNum;
        this.min = min;
        this.max = max;
        this.tooltip = tooltip;
    }

    @Override
    public void init() {
        Logger.debug((Object)this.parent.getTile());
        this.val = this.parent.getTile().getField(this.fieldNum);
    }

    private void changeVal(int dv) {
        this.val = this.val + dv > this.max ? this.max : (this.val + dv < this.min ? this.min : (this.val += dv));
    }

    @Override
    public void handle(int mouseX, int mouseY, int mouseButton, boolean shift) {
        int dv;
        int lowerUpper = this.y + 8;
        int upperLower = this.y + this.height - 8;
        int n = dv = shift ? 10 : 1;
        if (mouseY < lowerUpper) {
            this.changeVal(dv);
        } else if (mouseY > upperLower) {
            this.changeVal(-dv);
        }
        this.getParent().getTile().setField(this.fieldNum, this.val);
        PacketHandler.sendToServer(new NumberEntryPacket(this.fieldNum, this.val));
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void draw(int parX, int parY) {
        GlStateManager.func_179094_E();
        FacGuiHelper.bindTex("widgets");
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.x + parX, this.y + parY, 0, 20, this.width, this.height);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.toString(this.val), 4 + this.x + parX, 10 + this.y + parY, 0x303030);
        GlStateManager.func_179121_F();
    }
}

