/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DecoCoilLink {
    private Vec3d start;
    private Vec3d end;
    private Vec3d delta;
    private double distance;
    private double[][] positions = new double[3][3];
    private double[][] velocities = new double[3][3];
    private long[] prevTimes = new long[]{0L, 0L, 0L};
    private double[] targetTimes = new double[]{0.0, 0.0, 0.0};

    public DecoCoilLink(Vec3d startPoint, Vec3d endPoint) {
        this.start = startPoint;
        this.end = endPoint;
        this.delta = this.end.func_178788_d(this.start);
        this.distance = this.delta.func_72433_c();
    }

    public DecoCoilLink(BlockPos startPoint, BlockPos endPoint) {
        this(new Vec3d((Vec3i)startPoint), new Vec3d((Vec3i)endPoint));
    }

    public void update(World world) {
        for (int i = 0; i < 3; ++i) {
            if (this.positions[i] != null && !((double)(world.func_82737_E() - this.prevTimes[i]) >= this.targetTimes[i])) continue;
            this.positions[i] = new double[]{this.delta.field_72450_a * 0.25 * (double)(i + 1), this.delta.field_72448_b * 0.25 * (double)(i + 1), this.delta.field_72449_c * 0.25 * (double)(i + 1)};
            this.velocities[i] = new double[]{0.0, 0.0, 0.0};
            DecoCoilLink.randomOffset(this.positions[i], MathHelper.func_76133_a((double)this.distance) / 20.0f);
            DecoCoilLink.randomOffset(this.velocities[i], 0.025);
            this.prevTimes[i] = world.func_82737_E();
            this.targetTimes[i] = (Math.random() + 0.5) * 50.0;
        }
    }

    public void draw(World world, BufferBuilder buffer, double partialTicks) {
        buffer.func_181662_b(0.0, 0.1, 0.0).func_181666_a(0.5f, 0.5f, 1.0f, 1.0f).func_181675_d();
        for (int i = 0; i < 3; ++i) {
            double d = ((double)world.func_72820_D() + this.targetTimes[i]) % 20.0 + partialTicks;
            buffer.func_181662_b(this.positions[i][0] + d * this.velocities[i][0], this.positions[i][1] + d * this.velocities[i][1], this.positions[i][2] + d * this.velocities[i][2]).func_181666_a(0.5f, 0.5f, 1.0f, 1.0f).func_181675_d();
        }
        buffer.func_181662_b(this.delta.field_72450_a, this.delta.field_72448_b, this.delta.field_72449_c).func_181666_a(0.5f, 0.5f, 1.0f, 1.0f).func_181675_d();
    }

    public String toString() {
        return String.format("DecoCoilLink{start: %s, end: %s}", this.start, this.end);
    }

    private static void randomOffset(double[] vec, double factor) {
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] + (Math.random() - 0.5) * factor * 2.0;
        }
    }
}

