/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.DecoCoilLink;
import dalapo.factech.helper.Pair;
import dalapo.factech.tileentity.specialized.TileEntityDecoCoil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DecoCoilLinkGraph {
    private static final DCLG TEDCLINK = new DCLG();
    private Map<TileEntityDecoCoil, Set<TileEntityDecoCoil>> graph = new HashMap<TileEntityDecoCoil, Set<TileEntityDecoCoil>>();
    private Map<Pair<TileEntityDecoCoil, TileEntityDecoCoil>, DecoCoilLink> edgeMap = new HashMap<Pair<TileEntityDecoCoil, TileEntityDecoCoil>, DecoCoilLink>();

    public void merge(DecoCoilLinkGraph other) {
        for (TileEntityDecoCoil vertex : other.graph.keySet()) {
            this.addVertex(vertex);
            for (TileEntityDecoCoil connection : other.graph.get((Object)vertex)) {
                this.addEdge(vertex, connection);
            }
            vertex.setLinks(this, TEDCLINK);
        }
    }

    public void addVertex(TileEntityDecoCoil vertex) {
        if (vertex != null && !this.graph.containsKey((Object)vertex)) {
            this.graph.put(vertex, new HashSet());
        }
    }

    public void removeVertex(TileEntityDecoCoil vertex) {
        Iterable neighbours = this.graph.get((Object)vertex);
        this.graph.remove((Object)vertex);
        for (TileEntityDecoCoil connected : neighbours) {
            this.removeEdge(vertex, connected);
        }
    }

    public boolean hasEdge(TileEntityDecoCoil first, TileEntityDecoCoil second) {
        return this.graph.get((Object)first) != null && this.graph.get((Object)first).contains((Object)second);
    }

    public void addEdge(TileEntityDecoCoil first, TileEntityDecoCoil second) {
        if (first == null || second == null || ((Object)((Object)first)).equals((Object)second)) {
            return;
        }
        if (!this.graph.containsKey((Object)first)) {
            this.addVertex(first);
        }
        if (!this.graph.containsKey((Object)second)) {
            this.addVertex(second);
        }
        this.graph.get((Object)first).add(second);
        this.graph.get((Object)second).add(first);
        this.edgeMap.put(new Pair<TileEntityDecoCoil, TileEntityDecoCoil>(first, second), new DecoCoilLink(first.func_174877_v(), second.func_174877_v()));
        this.edgeMap.put(new Pair<TileEntityDecoCoil, TileEntityDecoCoil>(second, first), new DecoCoilLink(second.func_174877_v(), first.func_174877_v()));
    }

    public void removeEdge(TileEntityDecoCoil first, TileEntityDecoCoil second) {
        if (this.graph.containsKey((Object)first)) {
            this.graph.get((Object)first).remove((Object)second);
        }
        if (this.graph.containsKey((Object)second)) {
            this.graph.get((Object)second).remove((Object)first);
        }
        this.edgeMap.remove(new Pair<TileEntityDecoCoil, TileEntityDecoCoil>(first, second));
        this.edgeMap.remove(new Pair<TileEntityDecoCoil, TileEntityDecoCoil>(second, first));
    }

    public boolean isPowered(TileEntityDecoCoil source) {
        for (TileEntityDecoCoil vertex : this.getConnectedComponents(source)) {
            if (!vertex.isPowered()) continue;
            return true;
        }
        return false;
    }

    public Iterable<TileEntityDecoCoil> getNeighbours(TileEntityDecoCoil source) {
        if (this.graph.containsKey((Object)source)) {
            return this.graph.get((Object)source);
        }
        return new HashSet<TileEntityDecoCoil>();
    }

    public Iterable<DecoCoilLink> getOutgoingLinks(TileEntityDecoCoil source) {
        HashSet<DecoCoilLink> links = new HashSet<DecoCoilLink>();
        for (Pair<TileEntityDecoCoil, TileEntityDecoCoil> edge : this.edgeMap.keySet()) {
            if (!((Object)((Object)source)).equals(edge.a)) continue;
            links.add(this.edgeMap.get(edge));
        }
        return links;
    }

    public Iterable<TileEntityDecoCoil> getConnectedComponents(TileEntityDecoCoil source) {
        HashSet<TileEntityDecoCoil> checked = new HashSet<TileEntityDecoCoil>();
        LinkedList<TileEntityDecoCoil> toCheck = new LinkedList<TileEntityDecoCoil>();
        toCheck.add(source);
        while (!toCheck.isEmpty()) {
            TileEntityDecoCoil vertex = (TileEntityDecoCoil)((Object)toCheck.remove(0));
            if (this.graph.containsKey((Object)vertex)) {
                for (TileEntityDecoCoil neighbour : this.graph.get((Object)vertex)) {
                    if (checked.contains((Object)neighbour) || toCheck.contains((Object)neighbour) || ((Object)((Object)vertex)).equals((Object)neighbour)) continue;
                    toCheck.add(neighbour);
                }
            }
            checked.add(vertex);
        }
        return checked;
    }

    public static final class DCLG {
        private DCLG() {
        }
    }
}

