/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Logger;
import java.util.ArrayList;
import java.util.function.Predicate;

public class FacArrayHelper {
    private FacArrayHelper() {
    }

    public static int sum(int[] arr) {
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            count += arr[i];
        }
        return count;
    }

    public static boolean contains(Object[] arr, Object target) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] arr, Predicate<T> criterion) {
        for (T t : arr) {
            if (!criterion.test(t)) continue;
            return true;
        }
        return false;
    }

    public static void pushThrough(boolean[] arr, boolean newVal) {
        for (int i = arr.length - 1; i > 0; --i) {
            arr[i] = arr[i - 1];
        }
        arr[0] = newVal;
    }

    public static boolean matchAny(int[] a, int[] b) {
        for (int i = 0; i < FacMathHelper.getMin(a.length, b.length); ++i) {
            if (a[i] != b[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean matchAnyIgnoreIndex(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (a[i] != b[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static void printArray(int[] arr) {
        for (int i : arr) {
            Logger.info(i);
        }
    }

    public static <T> T[] removeNulls(T[] o) {
        ArrayList<T> arr = new ArrayList<T>();
        for (T t : o) {
            if (t == null) continue;
            arr.add(t);
        }
        return arr.toArray();
    }

    public static <T> T[] chop(T[] in, int newSize) {
        if (newSize < 0 || newSize >= in.length) {
            return in;
        }
        return in;
    }

    public static <T> int count(T[] arr, Predicate<T> condition) {
        int acc = 0;
        for (T t : arr) {
            if (!condition.test(t)) continue;
            ++acc;
        }
        return acc;
    }

    public static <T> String describeArray(T[] arr) {
        String str = "{";
        for (T t : arr) {
            str = str + t.toString() + "; ";
        }
        return str + "}";
    }
}

