/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.FacMathHelper;
import dalapo.factech.helper.Pair;
import dalapo.factech.reference.StateList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class FacBlockHelper {
    public static final Map<Pair<Item, Integer>, IPlantable> CROPS = new HashMap<Pair<Item, Integer>, IPlantable>();

    private FacBlockHelper() {
    }

    public static void updateBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }

    public static void updateNeighbours(World world, BlockPos pos, Block block) {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            FacBlockHelper.updateBlock(world, FacMathHelper.withOffset(pos, f));
            world.func_175666_e(pos, block);
            world.func_175685_c(pos, block, false);
        }
    }

    public static EnumFacing getBlockDir(World world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b(StateList.directions);
    }

    public static IBlockState rotateTo(World world, BlockPos pos, EnumFacing dir) {
        return world.func_180495_p(pos).func_177230_c().func_176203_a(dir.ordinal());
    }

    public static IBlockState rotateOnPlane(World world, BlockPos pos, EnumFacing dir) {
        if (dir == EnumFacing.UP || dir == EnumFacing.DOWN) {
            return world.func_180495_p(pos);
        }
        return world.func_180495_p(pos).func_177230_c().func_176203_a(dir.ordinal());
    }

    public static EnumFacing getDirection(World world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b(StateList.directions);
    }

    public static EnumFacing nextRotation(EnumFacing current, boolean plane) {
        int newRotation = 0;
        newRotation = plane ? (current.ordinal() + 1) % 4 + 2 : (current.ordinal() + 1) % 6;
        return EnumFacing.func_82600_a((int)newRotation);
    }

    public static Block getBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    static {
        CROPS.put(new Pair<Item, Integer>(Items.field_151014_N, 0), (IPlantable)Blocks.field_150464_aj);
        CROPS.put(new Pair<Item, Integer>(Items.field_151081_bc, 0), (IPlantable)Blocks.field_150394_bc);
        CROPS.put(new Pair<Item, Integer>(Items.field_151080_bb, 0), (IPlantable)Blocks.field_150393_bb);
        CROPS.put(new Pair<Item, Integer>(Items.field_185163_cU, 0), (IPlantable)Blocks.field_185773_cZ);
        CROPS.put(new Pair<Item, Integer>(Items.field_151172_bF, 0), (IPlantable)Blocks.field_150459_bM);
        CROPS.put(new Pair<Item, Integer>(Items.field_151174_bG, 0), (IPlantable)Blocks.field_150469_bN);
        CROPS.put(new Pair<Item, Integer>(Items.field_151075_bm, 0), (IPlantable)Blocks.field_150388_bm);
        CROPS.put(new Pair<Item, Integer>(Items.field_151120_aE, 0), (IPlantable)Blocks.field_150436_aH);
    }
}

