/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.FacGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FacFluidRenderHelper {
    private FacFluidRenderHelper() {
    }

    public static ResourceLocation getFluidTex(Fluid fluid, boolean isFlowing) {
        if (fluid == null) {
            return null;
        }
        if (isFlowing) {
            return fluid.getFlowing();
        }
        return fluid.getStill();
    }

    public static ResourceLocation getFluidTex(FluidStack fluid, boolean isFlowing) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        if (isFlowing) {
            return fluid.getFluid().getFlowing(fluid);
        }
        return fluid.getFluid().getStill(fluid);
    }

    public static TextureAtlasSprite getSprite(Fluid fluid, boolean isFlowing) {
        ResourceLocation loc = FacFluidRenderHelper.getFluidTex(fluid, isFlowing);
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString());
    }

    public static TextureAtlasSprite getSprite(FluidStack fluid, boolean isFlowing) {
        ResourceLocation loc = FacFluidRenderHelper.getFluidTex(fluid, isFlowing);
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString());
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), 0.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), 0.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawFluid(FluidStack fluid, int x, int y, int width, int height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite fluidSprite = FacFluidRenderHelper.getSprite(fluid, false);
        if (fluidSprite == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        FacGuiHelper.setColor(fluid.getFluid().getColor());
        FacFluidRenderHelper.drawTexturedModalRect(x, y + height - height * 16, fluidSprite, width, height * 16);
    }
}

