/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.helper.FacFluidRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FacGuiHelper {
    private FacGuiHelper() {
    }

    public static String formatTexName(String baseName) {
        return "factorytech:textures/gui/" + baseName + ".png";
    }

    public static void bindTex(String name) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(FacGuiHelper.formatTexName(name)));
    }

    public static void bindTex(ResourceLocation res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
    }

    public static void setColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void drawFluidTank(GuiContainer gui, int x, int y, int width, int height, int maxVal, FluidStack fluid) {
        if (fluid == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = FacFluidRenderHelper.getSprite(fluid, false);
        if (icon == null) {
            return;
        }
        int fillLevel = height * fluid.amount / maxVal;
    }

    public static ResourceLocation getItemTex(ItemStack is) {
        return new ResourceLocation(is.func_77977_a());
    }

    public static void renderItemStack(ItemStack is, int x, int y) {
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_175042_a(is, x, y);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, is, x, y, null);
    }

    public static void drawTexturedModalRect(int x, int y, double z, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), z).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), z).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), z).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), z).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return pointX >= rectX - 1 && pointX < rectX + rectWidth + 1 && pointY >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    public static void renderToolTip(GuiScreen parent, String text, int x, int y) {
        parent.func_146279_a(text, x, y);
    }
}

