/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import dalapo.factech.FactoryTech;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class FacMathHelper {
    private FacMathHelper() {
    }

    public static int getMin(int a, int b) {
        return a < b ? a : b;
    }

    public static int getMax(int a, int b) {
        return a > b ? a : b;
    }

    public static double clamp(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static boolean isInRange(int x, int min, int max) {
        return x >= min && x < max;
    }

    public static boolean isInRangeInclusive(int x, int min, int max) {
        return x >= min && x <= max;
    }

    public static BlockPos withOffset(BlockPos init, EnumFacing dir) {
        return FacMathHelper.withOffsetAndDist(init, dir, 1);
    }

    public static BlockPos withOffsetAndDist(BlockPos init, EnumFacing dir, int dist) {
        if (dir == null) {
            return init;
        }
        switch (dir) {
            case UP: {
                return init.func_177981_b(dist);
            }
            case DOWN: {
                return init.func_177979_c(dist);
            }
            case NORTH: {
                return init.func_177964_d(dist);
            }
            case SOUTH: {
                return init.func_177970_e(dist);
            }
            case WEST: {
                return init.func_177985_f(dist);
            }
            case EAST: {
                return init.func_177965_g(dist);
            }
        }
        return init;
    }

    public static double absDist(int dx, int dy, int dz) {
        return MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz));
    }

    public static double absDist(BlockPos a, BlockPos b) {
        return FacMathHelper.absDist(a.func_177958_n() - b.func_177958_n(), a.func_177956_o() - b.func_177956_o(), a.func_177952_p() - b.func_177952_p());
    }

    public static double absDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
    }

    public static EnumFacing getDirectionFromEntity(BlockPos clicked, EntityLivingBase elb) {
        return EnumFacing.func_176737_a((float)((float)(elb.field_70165_t - (double)clicked.func_177958_n())), (float)((float)(elb.field_70163_u - (double)clicked.func_177956_o())), (float)((float)(elb.field_70161_v - (double)clicked.func_177952_p())));
    }

    public static EnumFacing getDirectionFromEntityXZ(BlockPos clicked, EntityLivingBase elb) {
        return EnumFacing.func_176737_a((float)((float)(elb.field_70165_t - (double)clicked.func_177958_n())), (float)0.0f, (float)((float)(elb.field_70161_v - (double)clicked.func_177952_p())));
    }

    public static int sum(int[] arr) {
        int count = 0;
        for (int i : arr) {
            count += i;
        }
        return count;
    }

    public static int[][] identity(int size) {
        int[][] mtrx = new int[size][size];
        for (int i = 0; i < mtrx.length; ++i) {
            mtrx[i][i] = 1;
        }
        return mtrx;
    }

    public static float pyth(double a, double b) {
        return MathHelper.func_76133_a((double)(a * a + b * b));
    }

    public static double pyth3D(double a, double b, double c) {
        return MathHelper.func_76133_a((double)(a * a + b * b + c * c));
    }

    public static Vec3d rotateGeneral(Vec3d in, Vec3d axisLoc, int axis, float angle) {
        float radius = 0.0f;
        float theta = 0.0f;
        switch (axis) {
            case 0: {
                radius = FacMathHelper.pyth(in.field_72448_b - axisLoc.field_72448_b, in.field_72449_c - axisLoc.field_72449_c);
                theta = (float)MathHelper.func_181159_b((double)(in.field_72448_b - axisLoc.field_72448_b), (double)(in.field_72449_c - axisLoc.field_72449_c)) + angle;
                return new Vec3d(in.field_72450_a, (double)(radius * MathHelper.func_76126_a((float)theta)) + axisLoc.field_72448_b, (double)(radius * MathHelper.func_76134_b((float)theta)) + axisLoc.field_72449_c);
            }
            case 1: {
                radius = FacMathHelper.pyth(in.field_72449_c - axisLoc.field_72449_c, in.field_72450_a - axisLoc.field_72450_a);
                theta = (float)MathHelper.func_181159_b((double)(in.field_72449_c - axisLoc.field_72449_c), (double)(in.field_72450_a - axisLoc.field_72450_a));
                return new Vec3d((double)(radius * MathHelper.func_76134_b((float)theta)) + axisLoc.field_72450_a, in.field_72448_b, (double)(radius * MathHelper.func_76126_a((float)theta)) + axisLoc.field_72449_c);
            }
            case 2: {
                radius = FacMathHelper.pyth(in.field_72450_a - axisLoc.field_72450_a, in.field_72448_b - axisLoc.field_72448_b);
                theta = (float)MathHelper.func_181159_b((double)(in.field_72450_a - axisLoc.field_72450_a), (double)(in.field_72448_b - axisLoc.field_72448_b));
                return new Vec3d((double)(radius * MathHelper.func_76126_a((float)theta)) + axisLoc.field_72450_a, (double)(radius * MathHelper.func_76134_b((float)theta)) + axisLoc.field_72448_b, in.field_72449_c);
            }
        }
        return in;
    }

    public static EnumFacing clockwise(EnumFacing init) {
        switch (init) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return init;
    }

    public static double randomDistributed(double distance) {
        return (FactoryTech.random.nextDouble() - 0.5) * distance;
    }

    public static Vec3d randomOffset(Vec3d in, double dx, double dy, double dz) {
        double x = FacMathHelper.randomDistributed(dx);
        double y = FacMathHelper.randomDistributed(dy);
        double z = FacMathHelper.randomDistributed(dz);
        return in.func_178787_e(new Vec3d(x, y, z));
    }
}

