/*
 * Decompiled with CFR 0.152.
 */
package dalapo.factech.helper;

import com.mojang.authlib.GameProfile;
import dalapo.factech.helper.FacArrayHelper;
import dalapo.factech.helper.Logger;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidTank;

public class FacMiscHelper {
    private FacMiscHelper() {
    }

    public static boolean isDeobfEnvironment() {
        return !FMLForgePlugin.RUNTIME_DEOBF;
    }

    public static FakePlayer getFakePlayer(World world) {
        if (!world.field_72995_K) {
            return FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(UUID.randomUUID(), "[FactoryTech-Fake]"));
        }
        Logger.warn("Attempted to call getFakePlayer client-side. This should not be done!");
        return null;
    }

    public static boolean hasACPower(World world, BlockPos pos, boolean[] prevTicks) {
        boolean cur = world.func_175687_A(pos) != 0;
        boolean isAC = false;
        for (boolean b : prevTicks) {
            if (b == cur) continue;
            isAC = true;
        }
        FacArrayHelper.pushThrough(prevTicks, cur);
        return isAC;
    }

    public static String formatPath(String str) {
        return "factorytech:" + str;
    }

    public static void registerStateModel(Block block, int meta, String file) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)block), meta, new ModelResourceLocation("factorytech:" + file, "inventory"));
    }

    public static String capitalizeFirstLetter(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String describeTank(FluidTank tank) {
        if (tank.getFluid() == null) {
            return I18n.func_135052_a((String)"factorytech.tankempty", (Object[])new Object[0]);
        }
        return String.format("%s; %s / %s", tank.getFluid().getLocalizedName(), tank.getFluidAmount(), tank.getCapacity());
    }

    public static String describeList(List<?> list, String delimiter) {
        String builder = "";
        for (Object o : list) {
            builder = builder + o.toString() + delimiter;
        }
        return builder;
    }

    public static String describeBlockPos(BlockPos bp) {
        return String.format("(%s, %s, %s)", bp.func_177958_n(), bp.func_177956_o(), bp.func_177952_p());
    }
}

